<?php
// view/settings.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'settings';
 $pageTitle = $lang[$current_lang]['settings'] ?? 'Settings';

// Ambil data settings dari database
 $stmt = $pdo->query("SELECT * FROM settings");
 $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Format menjadi array key-value
 $settings = [];
foreach ($rows as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'bn' ? 'active' : '' ?>" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> <?= $lang[$current_lang]['profile'] ?? 'Profile' ?></a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['settings'] ?? 'Settings' ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['manage_settings_desc'] ?? 'Manage application settings' ?></p>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 col-md-12">
                
                <!-- Card 1: Pengaturan Aplikasi -->
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-cog me-2"></i>
                            <?= $lang[$current_lang]['app_settings'] ?? 'Application Settings' ?>
                        </h3>
                    </div>
                    <div class="card-body">
                        <form id="formSettings">
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['app_name'] ?? 'Application Name' ?></label>
                                <input type="text" name="app_name" class="form-control" value="<?= htmlspecialchars($settings['app_name'] ?? 'SmartWifi') ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['company_name'] ?? 'Company Name' ?></label>
                                <input type="text" name="company_name" class="form-control" value="<?= htmlspecialchars($settings['company_name'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['company_address'] ?? 'Address' ?></label>
                                <textarea name="company_address" class="form-control" rows="2"><?= htmlspecialchars($settings['company_address'] ?? '') ?></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['company_phone'] ?? 'Phone' ?></label>
                                    <input type="text" name="company_phone" class="form-control" value="<?= htmlspecialchars($settings['company_phone'] ?? '') ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['currency'] ?? 'Currency Symbol' ?></label>
                                    <input type="text" name="currency" class="form-control" value="<?= htmlspecialchars($settings['currency'] ?? 'Rp') ?>">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['footer_text'] ?? 'Footer Text' ?></label>
                                <input type="text" name="footer_text" class="form-control" value="<?= htmlspecialchars($settings['footer_text'] ?? '') ?>">
                            </div>

                            <button type="submit" class="btn btn-primary">
                                <i class="mdi mdi-content-save me-1"></i> <?= $lang[$current_lang]['save'] ?? 'Save' ?>
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Card 2: Pengaturan Telegram Bot -->
                <div class="card fade-in mt-4">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-telegram me-2"></i>
                            <?= $lang[$current_lang]['telegram_settings'] ?? 'Telegram Bot Settings' ?>
                        </h3>
                    </div>
                    <div class="card-body">
                        <form id="formTelegram">
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['telegram_token'] ?? 'Bot Token' ?></label>
                                <input type="text" name="telegram_token" class="form-control" value="<?= htmlspecialchars($settings['telegram_token'] ?? '') ?>" placeholder="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11">
                                <small class="text-muted">Dapatkan dari @BotFather di Telegram.</small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['telegram_chat_id'] ?? 'Chat ID' ?></label>
                                <input type="text" name="telegram_chat_id" class="form-control" value="<?= htmlspecialchars($settings['telegram_chat_id'] ?? '') ?>" placeholder="-1001234567890">
                                <small class="text-muted">ID Grup atau Channel (gunakan @RawDataBot untuk mendapatkan ID).</small>
                            </div>

                            <button type="submit" class="btn btn-info">
                                <i class="mdi mdi-check me-1"></i> Simpan Token
                            </button>
                            <!-- TOMBOL TEST BARU -->
                            <button type="button" id="btnTestTelegram" class="btn btn-secondary ms-2">
                                <i class="mdi mdi-send me-1"></i> Test Kirim
                            </button>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
    
    <footer class="footer">
        <p>SmartWifi Voucher System v<?= APP_VERSION ?></p>
    </footer>
</main>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    // Submit Form Utama
    $('#formSettings').on('submit', function(e) {
        e.preventDefault();
        saveSettings($(this));
    });

    // Submit Form Telegram
    $('#formTelegram').on('submit', function(e) {
        e.preventDefault();
        saveSettings($(this));
    });

    function saveSettings(formObj) {
        var formData = formObj.serialize();
        $.ajax({
            url: '../post/update_settings.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                } else {
                    showToast(response.message, 'error');
                }
            },
            error: function() {
                showToast('System Error', 'error');
            }
        });
    }

    // Logika Test Telegram
    $('#btnTestTelegram').on('click', function() {
        var btn = $(this);
        var originalText = btn.html();
        btn.prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> Mengirim...');

        $.ajax({
            url: '../post/test_telegram.php',
            method: 'POST',
            dataType: 'json',
            success: function(response) {
                showToast(response.message, response.status); // response.status adalah 'success' atau 'error'
                btn.prop('disabled', false).html(originalText);
            },
            error: function() {
                showToast('Gagal menghubungi server', 'error');
                btn.prop('disabled', false).html(originalText);
            }
        });
    });
});
</script>