<?php
// view/reports.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'reports';
 $pageTitle = $lang[$current_lang]['reports'] ?? 'Reports';

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';

// Ambil daftar lokasi untuk filter Admin
 $locations_list = [];
if ($user_role === 'admin') {
    $stmtLoc = $pdo->query("SELECT name FROM locations ORDER BY name ASC");
    $locations_list = $stmtLoc->fetchAll(PDO::FETCH_ASSOC);
}

// Default Tanggal
 $default_start = date('Y-m-01');
 $default_end = date('Y-m-d');

// Ambil setting currency dari database
 $currency_symbol = $app_setting['currency'] ?? 'Rp';

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Custom Style untuk Input & Dropdown Tema -->
<style>
    /* Paksa warna input dan select mengikuti tema */
    .form-control, .form-select {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border: 1px solid var(--primary) !important;
    }
    /* Warna teks pada opsi dropdown saat dibuka */
    .form-select option {
        background-color: var(--secondary);
        color: var(--text);
    }
    /* Warna saat input fokus */
    .form-control:focus, .form-select:focus {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border-color: var(--accent) !important;
        box-shadow: 0 0 0 0.1rem var(--accent) !important;
    }
    /* Perbaikan warna placeholder */
    .form-control::placeholder { 
        color: var(--text);
        opacity: 0.5; 
    }
</style>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider" style="border-color: var(--primary);"></li>
                    <li><a class="dropdown-item text-danger" style="color: #e94560 !important;" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['sales_report'] ?? 'Sales Report' ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['report_desc'] ?? 'View sales transaction history' ?></p>
            </div>
        </div>

        <!-- Filter Card -->
        <div class="card fade-in mb-4">
            <div class="card-body">
                <form id="filterForm" class="row g-3 align-items-end">
                    <?php if ($user_role === 'admin'): ?>
                    <div class="col-md-3">
                        <label class="form-label" style="color: var(--text);"><?= $lang[$current_lang]['location'] ?? 'Location' ?></label>
                        <!-- Dropdown ini akan otomatis mengikuti style CSS di atas -->
                        <select name="location" id="filterLocation" class="form-select">
                            <option value=""><?= $lang[$current_lang]['all_locations'] ?? 'All Locations' ?></option>
                            <?php foreach($locations_list as $loc): ?>
                            <option value="<?= $loc['name'] ?>"><?= $loc['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php else: ?>
                        <input type="hidden" name="location" value="<?= htmlspecialchars($user_location) ?>">
                    <?php endif; ?>

                    <div class="col-md-3">
                        <label class="form-label" style="color: var(--text);"><?= $lang[$current_lang]['start_date'] ?? 'Start Date' ?></label>
                        <input type="date" name="start_date" id="startDate" class="form-control" value="<?= $default_start ?>">
                    </div>

                    <div class="col-md-3">
                        <label class="form-label" style="color: var(--text);"><?= $lang[$current_lang]['end_date'] ?? 'End Date' ?></label>
                        <input type="date" name="end_date" id="endDate" class="form-control" value="<?= $default_end ?>">
                    </div>

                    <div class="col-md-3 d-flex gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">
                            <i class="mdi mdi-magnify"></i> <?= $lang[$current_lang]['filter'] ?? 'Filter' ?>
                        </button>
                        <button type="button" id="btnExport" class="btn btn-success">
                            <i class="mdi mdi-file-excel"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="card" style="margin:0; background-color: var(--secondary); border: 1px solid var(--primary);">
                    <div class="card-body d-flex align-items-center">
                        <div class="stat-icon bg-primary" style="width: 50px; height: 50px;">
                            <i class="mdi mdi-cart-check"></i>
                        </div>
                        <div class="ms-3">
                            <h4 id="totalSales" style="color: var(--text);">0</h4>
                            <small style="color: var(--text); opacity: 0.7;"><?= $lang[$current_lang]['total_transactions'] ?? 'Total Transactions' ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card" style="margin:0; background-color: var(--secondary); border: 1px solid var(--primary);">
                    <div class="card-body d-flex align-items-center">
                        <div class="stat-icon bg-success" style="width: 50px; height: 50px;">
                            <i class="mdi mdi-cash-multiple"></i>
                        </div>
                        <div class="ms-3">
                            <!-- Gunakan currency dari PHP -->
                            <h4 id="totalRevenue" style="color: var(--accent);"><?= htmlspecialchars($currency_symbol) ?> 0</h4>
                            <small style="color: var(--text); opacity: 0.7;"><?= $lang[$current_lang]['total_revenue'] ?? 'Total Revenue' ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Table -->
        <div class="card fade-in">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="tableReport">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th><?= $lang[$current_lang]['voucher_code'] ?? 'Code' ?></th>
                                <th><?= $lang[$current_lang]['name'] ?? 'Name' ?></th>
                                <th><?= $lang[$current_lang]['packet'] ?? 'Packet' ?></th>
                                <th><?= $lang[$current_lang]['price'] ?? 'Price' ?></th>
                                <?php if ($user_role === 'admin'): ?>
                                <th><?= $lang[$current_lang]['location'] ?? 'Location' ?></th>
                                <?php endif; ?>
                                <th>User</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <!-- Footer mengikuti database -->
        <p><?= htmlspecialchars($app_setting['footer_text'] ?? ('SmartWifi Voucher System v' . APP_VERSION)) ?></p>
    </footer>
</main>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    // Set currency symbol dari PHP untuk digunakan di JS
    var currencySymbol = '<?= htmlspecialchars($currency_symbol) ?>';

    // Init DataTable
    var tableReport = $('#tableReport').DataTable({
        retrieve: true,
        processing: true,
        language: {
            search: "",
            searchPlaceholder: "<?= $lang[$current_lang]['search'] ?? 'Search...' ?>"
        },
        ajax: {
            url: '../get/get_report_data.php',
            type: 'GET',
            data: function (d) {
                d.start_date = $('#startDate').val();
                d.end_date = $('#endDate').val();
                d.location = $('#filterLocation').val();
            },
            dataSrc: function(json) {
                // Update Summary Cards dengan currency dinamis
                $('#totalSales').text(json.count || 0);
                
                var rev = json.total || 0;
                $('#totalRevenue').text(currencySymbol + ' ' + parseFloat(rev).toLocaleString('id-ID'));
                
                return json.data;
            }
        },
        columns: [
            { data: 'tanggal', render: function(d) { return d ? d : '-'; } },
            { data: 'kode_voucher' },
            { data: 'nama_konsumen' },
            { data: 'packet' },
            { 
                data: 'harga', 
                render: function(data, type, row) {
                    // Gunakan currency dinamis
                    return currencySymbol + ' ' + parseFloat(data).toLocaleString('id-ID');
                }
            },
            <?php if ($user_role === 'admin'): ?>
            { data: 'lokasi' },
            <?php endif; ?>
            { data: 'dibuat_oleh' }
        ]
    });

    // Submit Filter
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        tableReport.ajax.reload();
    });

    // Export Button
    $('#btnExport').on('click', function() {
        var start = $('#startDate').val();
        var end = $('#endDate').val();
        var loc = $('#filterLocation').val();
        
        var url = '../get/export_report.php?start_date=' + start + '&end_date=' + end;
        if(loc) url += '&location=' + encodeURIComponent(loc);
        
        window.location.href = url;
    });
});
</script>

<style>
    /* Hover effect untuk dropdown item */
    .dropdown-item:hover {
        background-color: var(--accent) !important;
        color: #fff !important;
    }
</style>