<?php
// view/lokasi.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'locations';
 $pageTitle = $lang[$current_lang]['locations'] ?? 'Locations';

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Custom Style untuk Input & Dropdown Tema -->
<style>
    .form-control, .form-select {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border: 1px solid var(--primary) !important;
    }
    .form-control:focus, .form-select:focus {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border-color: var(--accent) !important;
        box-shadow: 0 0 0 0.1rem var(--accent) !important;
    }
</style>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider" style="border-color: var(--primary);"></li>
                    <li><a class="dropdown-item text-danger" style="color: #e94560 !important;" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['locations'] ?? 'Locations' ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['manage_locations_desc'] ?? 'Manage wifi locations' ?></p>
            </div>
            <div>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addLocationModal">
                    <i class="mdi mdi-plus"></i> <?= $lang[$current_lang]['add_new'] ?? 'Add New' ?>
                </button>
            </div>
        </div>

        <div class="card fade-in">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="tableLocations">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th><?= $lang[$current_lang]['name'] ?? 'Name' ?></th>
                                <th class="text-end"><?= $lang[$current_lang]['action'] ?? 'Action' ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <p><?= htmlspecialchars($app_setting['footer_text'] ?? ('SmartWifi Voucher System v' . APP_VERSION)) ?></p>
    </footer>
</main>
</div>

<!-- Modal Add Location -->
<div class="modal fade" id="addLocationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <form id="formAddLocation">
                <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                    <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-map-marker-plus me-2"></i><?= $lang[$current_lang]['add_location'] ?? 'Add Location' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--text);"><?= $lang[$current_lang]['location_name'] ?? 'Location Name' ?></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid var(--primary);">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?? 'Cancel' ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-check me-1"></i><?= $lang[$current_lang]['save'] ?? 'Save' ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit Location -->
<div class="modal fade" id="editLocationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <form id="formEditLocation">
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                    <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-map-marker-check me-2"></i><?= $lang[$current_lang]['edit_location'] ?? 'Edit Location' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--text);"><?= $lang[$current_lang]['location_name'] ?? 'Location Name' ?></label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid var(--primary);">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?? 'Cancel' ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-check me-1"></i><?= $lang[$current_lang]['save'] ?? 'Save' ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    // Init DataTable
    var tableLocations = $('#tableLocations').DataTable({
        retrieve: true,
        processing: true,
        language: {
            search: "",
            searchPlaceholder: "<?= $lang[$current_lang]['search'] ?? 'Search...' ?>"
        },
        ajax: {
            url: '../get/get_locations.php',
            type: 'GET',
            dataSrc: 'data'
        },
        columns: [
            { 
                data: null, 
                render: function (data, type, row, meta) {
                    return meta.row + 1;
                }
            },
            { data: 'name' },
            { 
                data: null, 
                render: function(data, type, row) {
                    return `
                        <div class="d-flex gap-2 justify-content-end">
                            <button class="btn btn-warning btn-sm btn-edit" data-id="${row.id}" data-name="${row.name}">
                                <i class="mdi mdi-pencil"></i>
                            </button>
                            <button class="btn btn-danger btn-sm btn-delete" data-id="${row.id}">
                                <i class="mdi mdi-trash-can"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // Event: Click Edit
    $('#tableLocations').on('click', '.btn-edit', function() {
        var id = $(this).data('id');
        var name = $(this).data('name');
        
        $('#edit_id').val(id);
        $('#edit_name').val(name);
        
        $('#editLocationModal').modal('show');
    });

    // Event: Submit Add
    $('#formAddLocation').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../post/add_location.php',
            method: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    $('#formAddLocation')[0].reset();
                    $('#addLocationModal').modal('hide');
                    tableLocations.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // Event: Submit Edit
    $('#formEditLocation').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../post/edit_location.php',
            method: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    $('#editLocationModal').modal('hide');
                    tableLocations.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // Event: Delete
    $('#tableLocations').on('click', '.btn-delete', function() {
        var id = $(this).data('id');
        if(confirm('<?= $lang[$current_lang]['confirm_delete'] ?? 'Are you sure?' ?>')) {
            $.ajax({
                url: '../post/delete_location.php',
                method: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(response) {
                    if(response.status === 'success') {
                        showToast(response.message, 'success');
                        tableLocations.ajax.reload();
                    } else {
                        showToast(response.message, 'error');
                    }
                }
            });
        }
    });
});
</script>