<?php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'konsumen';
 $pageTitle = $lang[$current_lang]['consumer'] ?? 'Consumer';

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';

// Variabel untuk menentukan apakah user bisa memilih lokasi (Admin)
 $can_select_location = ($user_role === 'admin');

// Ambil daftar lokasi untuk dropdown (jika Admin)
 $locations_list = [];
if ($can_select_location) {
    $stmtLocList = $pdo->query("SELECT id, name FROM locations ORDER BY name ASC");
    $locations_list = $stmtLocList->fetchAll(PDO::FETCH_ASSOC);
}

// Jika Guest, ambil paket berdasarkan lokasi user login
 $packet_list = [];
if (!$can_select_location && !empty($user_location)) {
    $stmtLocId = $pdo->prepare("SELECT id FROM locations WHERE name = ?");
    $stmtLocId->execute([$user_location]);
    $locData = $stmtLocId->fetch(PDO::FETCH_ASSOC);
    $loc_id = $locData['id'] ?? 0;

    $stmtPackets = $pdo->prepare("SELECT DISTINCT nama_paket, durasi_hari, price FROM vouchers WHERE location_id = ? AND status = 'active' ORDER BY price ASC");
    $stmtPackets->execute([$loc_id]);
    $packet_list = $stmtPackets->fetchAll(PDO::FETCH_ASSOC);
}

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'bn' ? 'active' : '' ?>" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-format-size"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><h6 class="dropdown-header"><?= $lang[$current_lang]['text_size'] ?? 'Text Size' ?></h6></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=xs">XS</a></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=m">M</a></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=l">L</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> <?= $lang[$current_lang]['profile'] ?? 'Profile' ?></a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['consumer'] ?? 'Consumer' ?></h1>
                <p class="page-subtitle">
                    <?= $lang[$current_lang]['manage'] ?? 'Manage' ?> - 
                    <?= $lang[$current_lang]['location'] ?? 'Location' ?>: 
                    <strong>
                        <?php if($can_select_location): ?>
                            <span class="text-info">All Locations (Admin)</span>
                        <?php else: ?>
                            <?= htmlspecialchars($user_location) ?>
                        <?php endif; ?>
                    </strong>
                </p>
            </div>
        </div>

        <div class="row">
            <!-- CARD KIRI: Form Konsumen -->
            <div class="col-lg-5 col-md-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-account-plus me-2"></i>
                            <span id="formTitle"><?= $lang[$current_lang]['new_consumer'] ?? 'New Consumer' ?></span>
                        </h3>
                    </div>
                    <div class="card-body">
                        <form id="formKonsumen">
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['phone_wa'] ?? 'Phone' ?></label>
                                <input type="text" name="phone" id="phone" class="form-control" placeholder="08xxxxxxxxxx" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['name'] ?? 'Name' ?></label>
                                <input type="text" name="nama" id="nama" class="form-control" required>
                            </div>
                            
                            <!-- Logic Lokasi -->
                            <?php if($can_select_location): ?>
                                <div class="mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['location'] ?? 'Location' ?></label>
                                    <select name="lokasi" id="selectLokasi" class="form-select select2" required>
                                        <option value="">-- Pilih Lokasi --</option>
                                        <?php foreach($locations_list as $loc): ?>
                                        <option value="<?= htmlspecialchars($loc['name']) ?>" data-id="<?= $loc['id'] ?>">
                                            <?= htmlspecialchars($loc['name']) ?>
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="lokasi" value="<?= htmlspecialchars($user_location) ?>">
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['floor'] ?? 'Floor' ?></label>
                                    <input type="text" name="floor" id="floor" class="form-control">
                                </div>
                                <div class="col-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['room'] ?? 'Room' ?></label>
                                    <input type="text" name="room" id="room" class="form-control">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['packet'] ?? 'Packet' ?></label>
                                <select name="packet" id="selectPacket" class="form-select select2" required>
                                    <option value="">-- <?= $lang[$current_lang]['select_packet'] ?? 'Select Packet' ?> --</option>
                                    <?php if(!$can_select_location): ?>
                                        <?php foreach($packet_list as $p): ?>
                                        <option value="<?= htmlspecialchars($p['nama_paket']) ?>" 
                                                data-harga="<?= $p['price'] ?>" 
                                                data-durasi="<?= $p['durasi_hari'] ?>">
                                            <?= htmlspecialchars($p['nama_paket']) ?> - Rp <?= number_format($p['price']) ?>
                                        </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <?php if(!$can_select_location && empty($packet_list)): ?>
                                    <small class="text-danger mt-2 d-block"><?= $lang[$current_lang]['no_voucher_stock'] ?? 'No voucher stock' ?></small>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['price'] ?? 'Price' ?></label>
                                <input type="text" name="harga_display" id="hargaDisplay" class="form-control" readonly>
                                <input type="hidden" name="price" id="priceHidden">
                                <input type="hidden" name="durasi_hari" id="durasiHidden">
                            </div>

                            <input type="hidden" name="tanggal" value="<?= date('Y-m-d') ?>">
                            
                            <button type="submit" class="btn btn-primary w-100 mt-3" id="btnSubmit">
                                <i class="mdi mdi-content-save me-1"></i> 
                                <?= $lang[$current_lang]['save_sales'] ?? 'Save' ?>
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- CARD KANAN: Daftar Konsumen -->
            <div class="col-lg-7 col-md-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-account-group me-2"></i>
                            <?= $lang[$current_lang]['consumer_list'] ?? 'Consumer List' ?>
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-hover" id="tableKonsumen">
                            <thead>
                                <tr>
                                    <th><?= $lang[$current_lang]['name'] ?? 'Name' ?></th>
                                    <th><?= $lang[$current_lang]['floor'] ?? 'Floor' ?></th>
                                    <th><?= $lang[$current_lang]['room'] ?? 'Room' ?></th>
                                    <th><?= $lang[$current_lang]['phone_wa'] ?? 'Phone' ?></th>
                                    <?php if($can_select_location): ?>
                                    <th><?= $lang[$current_lang]['location'] ?? 'Location' ?></th>
                                    <?php endif; ?>
                                    <th style="width: 120px;"><?= $lang[$current_lang]['action'] ?? 'Action' ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <p>
            <?= htmlspecialchars($app_setting['footer_text'] ?? 'SmartWifi Voucher System v'.APP_VERSION) ?>
        </p>
    </footer>
</main>
</div>

<!-- Modal Popup Voucher (Update Bahasa) -->
<div class="modal fade" id="voucherSuccessModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-check-circle text-success me-2"></i><?= $lang[$current_lang]['transaction_successful'] ?? 'Transaction Successful' ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
            </div>
            <div class="modal-body text-center" id="modalContentWrapper">
                <!-- Area yang akan dijadikan Gambar -->
                <div id="captureArea" style="padding: 20px; background-color: var(--secondary); color: var(--text);">
                    <h4 id="modalCompany" class="mb-1"></h4>
                    <p id="modalLocation" class="text-muted mb-3"></p>
                    
                    <div style="background: var(--primary); padding: 15px; border-radius: 10px; margin-bottom: 15px;">
                        <h2 id="modalCode" style="color: var(--accent); margin:0; font-weight:bold; letter-spacing: 2px;"></h2>
                    </div>

                    <!-- Container QR Code -->
                    <div id="qrcodeContainer" style="display: inline-block; padding: 10px; background: white; border-radius: 8px; margin-bottom: 15px;"></div>

                    <table class="table table-borderless table-sm text-start" style="color: var(--text);">
                        <tr>
                            <td width="40%"><?= $lang[$current_lang]['consumer_label'] ?? 'Consumer' ?></td>
                            <td>: <strong id="modalCustomer"></strong></td>
                        </tr>
                        <tr>
                            <td><?= $lang[$current_lang]['packet_label'] ?? 'Packet' ?></td>
                            <td>: <strong id="modalPacket"></strong></td>
                        </tr>
                        <tr>
                            <td><?= $lang[$current_lang]['price_label'] ?? 'Price' ?></td>
                            <td>: <strong id="modalPrice"></strong></td>
                        </tr>
                        <tr>
                            <td><?= $lang[$current_lang]['link_label'] ?? 'Login Link' ?></td>
                            <td>: <small id="modalLink" style="word-break: break-all;"></small></td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="modal-footer d-block" style="border-top: 1px solid var(--primary);">
                <div class="row g-2">
                    <div class="col-6">
                        <button type="button" id="btnDownloadImg" class="btn btn-info w-100">
                            <i class="mdi mdi-download"></i> <?= $lang[$current_lang]['download_jpg'] ?? 'Download JPG' ?>
                        </button>
                    </div>
                    <div class="col-6">
                        <button type="button" id="btnShareWa" class="btn btn-success w-100">
                            <i class="mdi mdi-whatsapp"></i> <?= $lang[$current_lang]['share_whatsapp'] ?? 'Share WhatsApp' ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<!-- Tambahkan Library QRCode dan html2canvas -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
 $(document).ready(function() {
    // Init Select2
    $('.select2').select2({ width: '100%' });

    // ==========================================================
    // VARIABEL BAHASA UNTUK JAVASCRIPT (WHATSAPP)
    // ==========================================================
    const lang_wa_title = "<?= $lang[$current_lang]['wa_msg_title'] ?? 'Voucher Wifi' ?>";
    const lang_wa_loc   = "<?= $lang[$current_lang]['wa_msg_loc'] ?? 'Location' ?>";
    const lang_wa_code  = "<?= $lang[$current_lang]['wa_msg_code'] ?? 'Code' ?>";
    const lang_wa_link  = "<?= $lang[$current_lang]['wa_msg_link'] ?? 'Link' ?>";
    const lang_wa_thanks= "<?= $lang[$current_lang]['wa_msg_thanks'] ?? 'Thank you' ?>";

    // 1. Logic untuk Admin memilih lokasi
    $('#selectLokasi').on('select2:select', function (e) {
        var loc_name = $(this).val();
        $('#selectPacket').empty().append('<option value="">Loading...</option>').trigger('change');
        $.ajax({
            url: '../get/get_packets.php',
            method: 'GET',
            data: { location: loc_name },
            dataType: 'json',
            success: function(data) {
                $('#selectPacket').empty().append('<option value="">-- Pilih Paket --</option>');
                if(data.length > 0){
                    $.each(data, function(key, val) {
                        var newOption = new Option(val.text, val.id, false, false);
                        $(newOption).data('harga', val.harga);
                        $(newOption).data('durasi', val.durasi);
                        $('#selectPacket').append(newOption);
                    });
                } else {
                    $('#selectPacket').append('<option value="">Tidak ada stok</option>');
                }
                $('#selectPacket').trigger('change');
            }
        });
    });

    // 2. Event Listener Select Packet
    $('#selectPacket').on('select2:select', function (e) {
        var selected = $(this).find(':selected');
        var harga = selected.data('harga');
        var durasi = selected.data('durasi');
        
        if(harga) {
            $('#hargaDisplay').val('Rp ' + parseFloat(harga).toLocaleString('id-ID'));
            $('#priceHidden').val(harga);
            $('#durasiHidden').val(durasi);
        } else {
            $('#hargaDisplay').val('');
            $('#priceHidden').val('');
            $('#durasiHidden').val('');
        }
    });

    // 3. Init DataTable
    var tableKonsumen = $('#tableKonsumen').DataTable({
        retrieve: true,
        processing: true,
        language: { search: "", searchPlaceholder: "<?= $lang[$current_lang]['search'] ?? 'Search...' ?>" },
        ajax: { url: '../get/get_konsumen.php', type: 'GET', dataSrc: 'data' },
        columns: [
            { data: 'nama' },
            { data: 'floor' },
            { data: 'room' },
            { data: 'phone' },
            <?php if($can_select_location): ?>
            { data: 'lokasi' },
            <?php endif; ?>
            { 
                data: null, 
                render: function(data, type, row) {
                    return `
                        <div class="d-flex gap-1">
                            <button class="btn btn-success btn-sm btn-pilih" 
                                    data-nama="${row.nama}" data-phone="${row.phone}" 
                                    data-floor="${row.floor}" data-room="${row.room}" data-lokasi="${row.lokasi}">
                                <i class="mdi mdi-check"></i>
                            </button>
                            <button class="btn btn-info btn-sm btn-detail" data-id="${row.id}">
                                <i class="mdi mdi-eye"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // 4. Event Tombol Pilih
    $('#tableKonsumen').on('click', '.btn-pilih', function() {
        $('#nama').val($(this).data('nama'));
        $('#phone').val($(this).data('phone'));
        $('#floor').val($(this).data('floor'));
        $('#room').val($(this).data('room'));

        <?php if($can_select_location): ?>
        var lokasi = $(this).data('lokasi');
        if(lokasi){
            $('#selectLokasi').val(lokasi).trigger('change.select2'); 
            $('#selectLokasi').trigger('change'); 
        }
        <?php endif; ?>

        $('html, body').animate({ scrollTop: $("#formKonsumen").offset().top - 100 }, 500);
        $('#selectPacket').focus();
    });

    // 5. Submit Form (DENGAN POPUP)
    $('#formKonsumen').on('submit', function(e) {
        e.preventDefault();
        
        <?php if($can_select_location): ?>
        if(!$('#selectLokasi').val()){
            showToast('Pilih lokasi terlebih dahulu', 'error');
            return;
        }
        <?php endif; ?>

        var formData = $(this).serialize();

        $.ajax({
            url: '../post/add_konsumen.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    // Reset Form
                    $('#formKonsumen')[0].reset();
                    $('#hargaDisplay').val('');
                    $('#selectPacket').val('').trigger('change'); 
                    <?php if($can_select_location): ?>
                    $('#selectLokasi').val('').trigger('change');
                    <?php endif; ?>
                    tableKonsumen.ajax.reload(); 

                    // --- LOGIC POPUP ---
                    var data = response.data;
                    
                    // Isi Data ke Modal
                    $('#modalCompany').text(data.company);
                    $('#modalLocation').text(data.location);
                    $('#modalCode').text(data.code);
                    $('#modalCustomer').text(data.customer);
                    $('#modalPacket').text(data.packet + ' (' + data.price + ')');
                    $('#modalPrice').text('Rp ' + parseInt(data.price).toLocaleString('id-ID'));
                    $('#modalLink').text(data.link);

                    // Generate QR Code (Clear old first)
                    $('#qrcodeContainer').empty();
                    new QRCode(document.getElementById("qrcodeContainer"), {
                        text: data.link,
                        width: 128,
                        height: 128
                    });

                    // Set Data for Sharing (Menggunakan variabel bahasa)
                    var wa_text = `*${lang_wa_title} ${data.company}*\n${lang_wa_loc}: ${data.location}\n${lang_wa_code}: ${data.code}\n${lang_wa_link}: ${data.link}\n\n_${lang_wa_thanks}_`;
                    
                    $('#btnShareWa').data('phone', data.phone);
                    $('#btnShareWa').data('text', wa_text);

                    // Tampilkan Modal
                    $('#voucherSuccessModal').modal('show');
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // 6. Event Share WhatsApp
    $('#btnShareWa').on('click', function() {
        var phone = $(this).data('phone');
        var text = $(this).data('text');
        
        // Bersihkan nomor telepon
        phone = phone.replace(/\D/g, '');
        if(phone.startsWith('0')) {
            phone = '62' + phone.substring(1);
        }

        var url = `https://wa.me/${phone}?text=${encodeURIComponent(text)}`;
        window.open(url, '_blank');
    });

    // 7. Event Download Image
    $('#btnDownloadImg').on('click', function() {
        html2canvas(document.querySelector("#captureArea")).then(canvas => {
            var link = document.createElement('a');
            link.download = 'voucher.jpg';
            link.href = canvas.toDataURL();
            link.click();
        });
    });
});
</script>