<?php
// post/delete_user.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $id = $_POST['id'] ?? 0;

// Mencegah admin menghapus dirinya sendiri
if ($id == $_SESSION['user_id']) {
    echo json_encode(['status' => 'error', 'message' => 'Cannot delete yourself']);
    exit;
}

try {
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$id]);
    
    echo json_encode(['status' => 'success', 'message' => 'User deleted successfully']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error']);
}