<?php
// post/delete_selected_voucher.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $ids = $_POST['ids'] ?? [];

if (empty($ids)) {
    echo json_encode(['status' => 'error', 'message' => 'No IDs selected']);
    exit;
}

try {
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    
    $stmt = $pdo->prepare("DELETE FROM vouchers WHERE id IN ($placeholders)");
    $stmt->execute($ids);

    echo json_encode(['status' => 'success', 'message' => count($ids) . ' vouchers deleted']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error']);
}