<?php
// post/add_location.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $name = $_POST['name'] ?? '';

if (empty($name)) {
    echo json_encode(['status' => 'error', 'message' => 'Name is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("INSERT INTO locations (name) VALUES (?)");
    $stmt->execute([$name]);
    
    echo json_encode(['status' => 'success', 'message' => 'Location added successfully']);
} catch (PDOException $e) {
    // Cek error duplicate entry
    if ($e->errorInfo[1] == 1062) {
        echo json_encode(['status' => 'error', 'message' => 'Location name already exists']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}