<?php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi Keamanan Lokasi
    $lokasi_input = $_POST['lokasi'] ?? '';
    
    if ($_SESSION['role'] !== 'admin') {
        $lokasi = $_SESSION['location'];
    } else {
        $lokasi = $lokasi_input;
    }

    $phone     = $_POST['phone'] ?? '';
    $nama      = $_POST['nama'] ?? '';
    $floor     = $_POST['floor'] ?? '';
    $room      = $_POST['room'] ?? '';
    $packet    = $_POST['packet'] ?? '';
    $price     = $_POST['price'] ?? 0;
    $durasi    = $_POST['durasi_hari'] ?? 0;
    $tanggal   = $_POST['tanggal'] ?? date('Y-m-d');

    // Cek apakah ada data kosong
    if (empty($phone) || empty($nama) || empty($packet) || empty($lokasi)) {
        $msg_empty = $lang[$current_lang]['no_data'] ?? 'Data tidak lengkap';
        echo json_encode(['status' => 'error', 'message' => $msg_empty]);
        exit;
    }

    try {
        // 1. Cari ID Lokasi
        $stmtLoc = $pdo->prepare("SELECT id FROM locations WHERE name = ?");
        $stmtLoc->execute([$lokasi]);
        $locData = $stmtLoc->fetch(PDO::FETCH_ASSOC);
        $location_id = $locData['id'] ?? 0;

        if ($location_id == 0) {
            echo json_encode(['status' => 'error', 'message' => 'Lokasi tidak valid']);
            exit;
        }

        // 2. Cari Voucher
        $stmtVoucher = $pdo->prepare("SELECT * FROM vouchers 
                                      WHERE location_id = ? 
                                      AND nama_paket = ? 
                                      AND price = ? 
                                      AND status = 'active' 
                                      LIMIT 1");
        $stmtVoucher->execute([$location_id, $packet, $price]);
        $voucher = $stmtVoucher->fetch(PDO::FETCH_ASSOC);

        if ($voucher) {
            $pdo->beginTransaction();

            // 3. Insert Konsumen
            $stmtK = $pdo->prepare("INSERT INTO konsumen (nama, phone, lokasi, floor, room) VALUES (?, ?, ?, ?, ?)");
            $stmtK->execute([$nama, $phone, $lokasi, $floor, $room]);
            $konsumen_id = $pdo->lastInsertId();

            // 4. Insert Penjualan
            $expire_date = date('Y-m-d', strtotime("+" . $durasi . " days"));
            $dibuat_oleh = $_SESSION['username'] ?? 'System';

            $stmtP = $pdo->prepare("INSERT INTO penjualan_voucher 
                                    (konsumen_id, phone, nama_konsumen, floor, room, packet, durasi_hari, harga, kode_voucher, lokasi, tanggal, expire_date, dibuat_oleh) 
                                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmtP->execute([
                $konsumen_id, $phone, $nama, $floor, $room, $packet, $durasi, $price,
                $voucher['code'], $lokasi, $tanggal, $expire_date, $dibuat_oleh
            ]);

            // 5. Update Voucher
            $stmtUpd = $pdo->prepare("UPDATE vouchers SET status = 'used' WHERE id = ?");
            $stmtUpd->execute([$voucher['id']]);

            $pdo->commit();

            // 6. Kirim Notifikasi Telegram (Dengan cURL)
            $company_name = $app_setting['app_name'] ?? 'SmartWifi';
            $login_link = $voucher['link'];
            
            // Ambil terjemahan
            $tg_title    = $lang[$current_lang]['tg_title'] ?? 'NEW SALE';
            $tg_company  = $lang[$current_lang]['tg_company'] ?? 'Company';
            $tg_loc      = $lang[$current_lang]['tg_loc'] ?? 'Location';
            $tg_name     = $lang[$current_lang]['tg_name'] ?? 'Name';
            $tg_phone    = $lang[$current_lang]['tg_phone'] ?? 'Phone';
            $tg_voucher  = $lang[$current_lang]['tg_voucher'] ?? 'Voucher';
            $tg_packet   = $lang[$current_lang]['tg_packet'] ?? 'Packet';
            $tg_price    = $lang[$current_lang]['tg_price'] ?? 'Price';
            $tg_admin    = $lang[$current_lang]['tg_admin'] ?? 'Admin';
            $tg_link     = $lang[$current_lang]['tg_link'] ?? 'Link';

            // Bangun pesan
            $message_text = "🔔 *{$tg_title}*\n\n";
            $message_text .= "🏢 *{$tg_company}:* $company_name\n";
            $message_text .= "📍 *{$tg_loc}:* $lokasi\n";
            $message_text .= "👤 *{$tg_name}:* $nama\n";
            $message_text .= "📱 *{$tg_phone}:* $phone\n";
            $message_text .= "🎫 *{$tg_voucher}:* `".$voucher['code']."`\n";
            $message_text .= "📦 *{$tg_packet}:* $packet ($durasi Hari)\n";
            $message_text .= "💰 *{$tg_price}:* Rp " . number_format($price) . "\n";
            $message_text .= "👤 *{$tg_admin}:* $dibuat_oleh\n";
            $message_text .= "🔗 *{$tg_link}:* $login_link";

            $telegram_token = $app_setting['telegram_token'] ?? '';
            $telegram_chat_id = $app_setting['telegram_chat_id'] ?? '';

            // Kirim Hanya jika Token dan Chat ID ada
            if (!empty($telegram_token) && !empty($telegram_chat_id)) {
                $url = "https://api.telegram.org/bot" . $telegram_token . "/sendMessage";
                
                $data = [
                    'chat_id'    => $telegram_chat_id,
                    'text'       => $message_text,
                    'parse_mode' => 'Markdown'
                ];

                // Inisialisasi cURL
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Nonaktifkan SSL verify untuk hosting tertentu
                
                // Eksekusi
                $result = curl_exec($ch);
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                
                // Opsional: Log jika gagal (cek file error_log di server)
                if ($http_code != 200) {
                    // Anda bisa menulis log ke file jika perlu debugging
                    // file_put_contents('telegram_error.log', "Error: $result \n", FILE_APPEND);
                }
            }

            // 7. Return Data untuk Frontend
            $success_msg = $lang[$current_lang]['add_success'] ?? 'Voucher berhasil dijual';
            
            echo json_encode([
                'status' => 'success', 
                'message' => $success_msg,
                'data' => [
                    'code' => $voucher['code'],
                    'link' => $login_link,
                    'company' => $company_name,
                    'location' => $lokasi,
                    'customer' => $nama,
                    'phone' => $phone,
                    'packet' => $packet,
                    'price' => $price,
                    'expire' => $expire_date
                ]
            ]);

        } else {
            $error_msg = $lang[$current_lang]['no_voucher_stock'] ?? 'Stok voucher habis atau tidak cocok';
            echo json_encode(['status' => 'error', 'message' => $error_msg]);
        }
    } catch (PDOException $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}