<?php
// get/export_report.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    exit;
}

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';

 $start_date = $_GET['start_date'] ?? date('Y-m-01');
 $end_date = $_GET['end_date'] ?? date('Y-m-d');
 $filter_location = $_GET['location'] ?? '';

try {
    $sql_where = "WHERE tanggal BETWEEN ? AND ?";
    $params = [$start_date, $end_date];

    if ($user_role !== 'admin') {
        $sql_where .= " AND lokasi = ?";
        $params[] = $user_location;
    } else {
        if (!empty($filter_location)) {
            $sql_where .= " AND lokasi = ?";
            $params[] = $filter_location;
        }
    }

    $stmt = $pdo->prepare("SELECT tanggal, kode_voucher, nama_konsumen, phone, floor, room, packet, durasi_hari, harga, lokasi, expire_date, dibuat_oleh FROM penjualan_voucher $sql_where ORDER BY tanggal DESC");
    $stmt->execute($params);
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Header CSV
    $filename = "laporan_penjualan_" . $start_date . "_sd_" . $end_date . ".csv";
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    
    // Buka output stream
    $output = fopen('php://output', 'w');
    
    // BOM for Excel UTF-8 compatibility
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

    // Header Kolom
    fputcsv($output, ['Tanggal', 'Kode Voucher', 'Nama Konsumen', 'Phone', 'Lantai', 'Kamar', 'Paket', 'Durasi (Hari)', 'Harga', 'Lokasi', 'Expire Date', 'Dibuat Oleh']);

    // Isi Data
    foreach ($data as $row) {
        fputcsv($output, $row);
    }

    fclose($output);

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}