<!-- view/includes/sidebar.php -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <a href="dashboard.php" class="sidebar-logo">
            <div class="logo-icon">
                <svg viewBox="0 0 48 48" fill="none">
                    <path d="M24 4L42 14V34L24 44L6 34V14L24 4Z" stroke="currentColor" stroke-width="2" fill="none"/>
                    <path d="M24 14L33 19.5V30.5L24 36L15 30.5V19.5L24 14Z" fill="currentColor" opacity="0.3"/>
                    <circle cx="24" cy="24" r="4" fill="currentColor"/>
                </svg>
            </div>
            <div class="logo-text">
                <h1>SpareParts</h1>
                <span>Management</span>
            </div>
        </a>
    </div>
    
    <nav class="sidebar-menu">
        <!-- ===================== -->
        <!-- 1. DASHBOARD -->
        <!-- ===================== -->
        <div class="menu-section">
            <a href="dashboard.php" class="menu-item <?= ($activePage == 'dashboard') ? 'active' : '' ?>">
                <i class="mdi mdi-view-dashboard"></i>
                <span><?= $lang[$current_lang]['dashboard'] ?></span>
            </a>
        </div>

        <!-- ===================== -->
        <!-- 2. MASTER DATA -->
        <!-- ===================== -->
        <div class="menu-section">
            <div class="menu-section-title">Master Data</div>
            
            <a href="category.php" class="menu-item <?= ($activePage == 'category') ? 'active' : '' ?>">
                <i class="mdi mdi-folder-outline"></i>
                <span><?= $lang[$current_lang]['category'] ?></span>
            </a>
            
            <a href="locations.php" class="menu-item <?= ($activePage == 'locations') ? 'active' : '' ?>">
                <i class="mdi mdi-map-marker-outline"></i>
                <span><?= $lang[$current_lang]['locations'] ?></span>
            </a>
            
            <a href="material_group.php" class="menu-item <?= ($activePage == 'material_group') ? 'active' : '' ?>">
                <i class="mdi mdi-group"></i>
                <span><?= $lang[$current_lang]['material_group'] ?></span>
            </a>

            <a href="mesin.php" class="menu-item <?= ($activePage == 'mesin') ? 'active' : '' ?>">
                <i class="mdi mdi-cogs"></i>
                <span><?= $lang[$current_lang]['machines'] ?></span>
            </a>

            <a href="line.php" class="menu-item <?= ($activePage == 'line') ? 'active' : '' ?>">
               <i class="mdi mdi-vector-line"></i>
               <span><?= $lang[$current_lang]['lines'] ?></span>
            </a>            

        </div>

        <!-- ===================== -->
        <!-- 3. INVENTORY -->
        <!-- ===================== -->
        <div class="menu-section">
            <div class="menu-section-title">Inventory</div>
            
            <a href="spareparts.php" class="menu-item <?= ($activePage == 'spareparts') ? 'active' : '' ?>">
                <i class="mdi mdi-cog"></i>
                <span><?= $lang[$current_lang]['spareparts'] ?></span>
                <?php 
                // Ambil jumlah spareparts untuk badge
                $stmt_badge = $pdo->query("SELECT COUNT(*) FROM spareparts");
                $count_sp = $stmt_badge->fetchColumn();
                ?>
                <span class="menu-badge"><?= $count_sp ?></span>
            </a>
            
            <a href="scan_image.php" class="menu-item <?= ($activePage == 'scan_image') ? 'active' : '' ?>">
               <i class="mdi mdi-camera"></i>
               <span><?= $lang[$current_lang]['scan_image'] ?></span>
            </a>

            <a href="import_spareparts.php" class="menu-item <?= ($activePage == 'import_spareparts') ? 'active' : '' ?>">
                <i class="mdi mdi-database-import"></i>
                <span>Import Data</span>
            </a>
        </div>

        <!-- ===================== -->
        <!-- 4. TRANSAKSI (BARU) -->
        <!-- ===================== -->
        <div class="menu-section">
            <div class="menu-section-title">Transaksi</div>
            
            <a href="transaksi_penerimaan.php" class="menu-item <?= ($activePage == 'transaksi_penerimaan') ? 'active' : '' ?>">
                <i class="mdi mdi-inbox-arrow-down"></i>
                <span><?= $lang[$current_lang]['goods_receipt'] ?></span>
            </a>
            
            <a href="transaksi_penarikan.php" class="menu-item <?= ($activePage == 'transaksi_penarikan') ? 'active' : '' ?>">
                <i class="mdi mdi-package-variant-closed-minus"></i>
                <span><?= $lang[$current_lang]['transaksi_penarikan'] ?></span>
            </a>
            
            <a href="transaksi_return.php" class="menu-item <?= ($activePage == 'transaksi_return') ? 'active' : '' ?>">
                <i class="mdi mdi-backup-restore"></i>
                <span><?= $lang[$current_lang]['transaksi_return'] ?></span>
            </a>

            <a href="po_list.php" class="menu-item <?= ($activePage == 'po_list') ? 'active' : '' ?>">
               <i class="mdi mdi-file-document-outline"></i>
               <span><?= $lang[$current_lang]['po_list'] ?></span>
            </a>
        </div>

        <!-- ===================== -->
        <!-- 5. ADMINISTRATION -->
        <!-- ===================== -->
        <?php if ($_SESSION['role'] === 'admin'): ?>
        <div class="menu-section">
            <div class="menu-section-title">Administration</div>
            <a href="users.php" class="menu-item <?= ($activePage == 'users') ? 'active' : '' ?>">
                <i class="mdi mdi-account-group"></i>
                <span><?= $lang[$current_lang]['users'] ?></span>
            </a>
            <a href="settings.php" class="menu-item <?= ($activePage == 'settings') ? 'active' : '' ?>">
                <i class="mdi mdi-cog-outline"></i>
                <span><?= $lang[$current_lang]['settings'] ?></span>
            </a>
        </div>
        <?php endif; ?>
    </nav>
    
    <div class="sidebar-footer">
        <div class="user-info">
            <div class="user-avatar">
                <?= strtoupper(substr($_SESSION['name'], 0, 1)) ?>
            </div>
            <div class="user-details">
                <h4><?= htmlspecialchars($_SESSION['name']) ?></h4>
                <span><?= ucfirst($_SESSION['role']) ?></span>
            </div>
        </div>
    </div>
</aside>