<!-- view/includes/header.php -->
<header class="header">
    <div class="header-left">
        <button class="sidebar-toggle" id="sidebarToggle">
            <i class="mdi mdi-menu"></i>
        </button>
        <nav class="breadcrumb">
            <a href="dashboard.php">Home</a>
            <i class="mdi mdi-chevron-right"></i>
            <span><?= $pageTitle ?? 'Page' ?></span>
        </nav>
    </div>
    <div class="header-right">
        <!-- Language -->
        <div class="dropdown">
            <button class="header-btn" data-bs-toggle="dropdown">
                <i class="mdi mdi-translate"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
            </ul>
        </div>
        
        <!-- Theme -->
        <div class="dropdown">
            <button class="header-btn" data-bs-toggle="dropdown">
                <i class="mdi mdi-palette"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
            </ul>
        </div>
        
        <!-- Font Size -->
        <div class="dropdown">
            <button class="header-btn" data-bs-toggle="dropdown">
                <i class="mdi mdi-format-size"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><h6 class="dropdown-header">Text Size</h6></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=xs">Extra Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=s">Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=m">Medium</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=l">Large</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><h6 class="dropdown-header">Button Size</h6></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=xs">Extra Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=s">Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=m">Medium</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=l">Large</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><h6 class="dropdown-header">Icon Size</h6></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=xs">Extra Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=s">Small</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=m">Medium</a></li>
                <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=l">Large</a></li>
            </ul>
        </div>
        
        <!-- Notifications -->
        <?php
        // Fetch low stock items for notification
        $stmt_notif = $pdo->query("SELECT COUNT(*) FROM spareparts WHERE stock < min_stock");
        $low_stock_count = $stmt_notif->fetchColumn();
        
        $stmt_items = $pdo->query("SELECT id, name, stock FROM spareparts WHERE stock < min_stock ORDER BY stock ASC LIMIT 5");
        $low_stock_items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);
        ?>
        <div class="dropdown">
            <button class="header-btn" data-bs-toggle="dropdown">
                <i class="mdi mdi-bell-outline"></i>
                <?php if ($low_stock_count > 0): ?>
                <span class="badge"><?= $low_stock_count ?></span>
                <?php endif; ?>
            </button>
            <ul class="dropdown-menu dropdown-menu-end" style="width: 300px;">
                <li><h6 class="dropdown-header">Low Stock Alert</h6></li>
                <?php if (empty($low_stock_items)): ?>
                    <li><span class="dropdown-item text-center text-muted small">No alerts</span></li>
                <?php else: ?>
                    <?php foreach ($low_stock_items as $item): ?>
                    <li><a class="dropdown-item" href="spareparts.php?id=<?= $item['id'] ?>">
                        <div class="d-flex justify-content-between">
                            <span><?= htmlspecialchars($item['name']) ?></span>
                            <span class="text-danger"><?= $item['stock'] ?> left</span>
                        </div>
                    </a></li>
                    <?php endforeach; ?>
                <?php endif; ?>
            </ul>
        </div>
        
        <!-- User Menu -->
        <div class="dropdown">
            <button class="header-btn" data-bs-toggle="dropdown">
                <i class="mdi mdi-account"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
            </ul>
        </div>
    </div>
</header>