<?php
// view/import_spareparts.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'import_spareparts';
 $pageTitle = $lang[$current_lang]['import_spareparts'];

// Ambil data untuk info reference
 $categories = $pdo->query("SELECT name FROM category WHERE status='active' ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
 $locations = $pdo->query("SELECT name FROM locations WHERE status='active' ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
 $groups = $pdo->query("SELECT name FROM material_group WHERE status='active' ORDER BY name")->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - <?= $pageTitle ?></title>
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../assets/css/dinar.css" rel="stylesheet">

    <style>
        .import-card {
            background: var(--card-bg);
            border: 1px solid var(--card-border);
            border-radius: 16px;
            box-shadow: var(--shadow);
        }
        .import-header {
            padding: 24px;
            border-bottom: 1px solid var(--card-border);
            display: flex;
            align-items: center;
            gap: 16px;
        }
        .import-icon {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #00d26a, #0d2818);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: #fff;
        }
        .import-body {
            padding: 24px;
        }
        .file-upload-area {
            border: 2px dashed var(--input-border);
            border-radius: 12px;
            padding: 40px;
            text-align: center;
            transition: var(--transition);
            cursor: pointer;
            background: var(--input-bg);
        }
        .file-upload-area:hover {
            border-color: var(--accent);
            background: var(--hover);
        }
        .file-upload-area.dragover {
            border-color: var(--accent);
            background: rgba(233, 69, 96, 0.1);
        }
        .reference-box {
            background: rgba(0, 210, 106, 0.1);
            border: 1px solid rgba(0, 210, 106, 0.3);
            border-radius: 10px;
            padding: 16px;
            font-size: 13px;
        }
        .reference-box strong {
            color: var(--accent);
        }
    </style>
</head>

<body data-theme="<?= $current_theme ?>" 
      class="text-size-<?= $current_text_size ?> 
             btn-size-<?= $current_btn_size ?> 
             icon-size-<?= $current_icon_size ?>">

    <div class="app-wrapper">
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <?php include 'includes/header.php'; ?>
            
            <div class="page-content">
                <div class="page-header fade-in">
                    <div>
                        <h1 class="page-title"><?= $pageTitle ?></h1>
                        <p class="page-subtitle"><?= $lang[$current_lang]['import_subtitle'] ?></p>
                    </div>
                    <a href="spareparts.php" class="btn btn-secondary">
                        <i class="mdi mdi-arrow-left"></i> <?= $lang[$current_lang]['back_to_list'] ?>
                    </a>
                </div>
                
                <div class="row">
                    <div class="col-lg-8 mb-4">
                        <div class="import-card fade-in">
                            <div class="import-header">
                                <div class="import-icon">
                                    <i class="mdi mdi-file-excel"></i>
                                </div>
                                <div>
                                    <h4 class="mb-0"><?= $lang[$current_lang]['upload_file_excel'] ?></h4>
                                    <small class="text-muted"><?= $lang[$current_lang]['file_format_info'] ?></small>
                                </div>
                            </div>
                            <div class="import-body">
                                <form action="../post/spareparts_action.php" method="POST" enctype="multipart/form-data" id="uploadForm">
                                    <input type="hidden" name="action" value="import">
                                    
                                    <div class="file-upload-area mb-3" id="dropZone">
                                        <input type="file" name="file_excel" id="fileInput" accept=".xls,.xlsx" hidden required>
                                        <i class="mdi mdi-cloud-upload-outline mdi-48px text-muted mb-3"></i>
                                        <h5><?= $lang[$current_lang]['drag_drop'] ?></h5>
                                        <p class="text-muted"><?= $lang[$current_lang]['or_click_select'] ?></p>
                                        <div id="fileNameDisplay" class="mt-3 fw-bold text-success" style="display:none;"></div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <a href="../get/template_spareparts.php" class="btn btn-outline-success">
                                            <i class="mdi mdi-download"></i> <?= $lang[$current_lang]['download_template'] ?>
                                        </a>
                                        <button type="submit" class="btn btn-primary btn-lg" id="btnUpload">
                                            <i class="mdi mdi-check-circle"></i> <?= $lang[$current_lang]['process_import'] ?>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div class="import-card fade-in">
                            <div class="card-header bg-transparent">
                                <h5 class="mb-0"><i class="mdi mdi-information-outline me-2"></i><?= $lang[$current_lang]['import_guide'] ?></h5>
                            </div>
                            <div class="card-body">
                                <ol class="mb-3" style="padding-left: 18px; color: var(--text-muted); font-size: 13px;">
                                    <li class="mb-2"><?= $lang[$current_lang]['guide_step1'] ?></li>
                                    <li class="mb-2"><?= $lang[$current_lang]['guide_step2'] ?></li>
                                    <li class="mb-2"><?= $lang[$current_lang]['guide_step3'] ?></li>
                                    <li class="mb-2"><?= $lang[$current_lang]['guide_step4'] ?></li>
                                    <li><?= $lang[$current_lang]['guide_step5'] ?></li>
                                </ol>

                                <div class="reference-box">
                                    <strong><?= $lang[$current_lang]['master_data_available'] ?></strong><br>
                                    <span class="text-size-xs">
                                        <?= $lang[$current_lang]['category'] ?>: <?= implode(', ', $categories) ?><br>
                                        <?= $lang[$current_lang]['locations'] ?>: <?= implode(', ', $locations) ?><br>
                                        <?= $lang[$current_lang]['material_group'] ?>: <?= implode(', ', $groups) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php include 'includes/footer.php'; ?>
        </main>
    </div>
    
    <script>
        // Logic Drag & Drop
        const dropZone = document.getElementById('dropZone');
        const fileInput = document.getElementById('fileInput');
        const fileNameDisplay = document.getElementById('fileNameDisplay');

        dropZone.addEventListener('click', () => fileInput.click());

        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('dragover');
        });

        dropZone.addEventListener('dragleave', () => {
            dropZone.classList.remove('dragover');
        });

        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('dragover');
            
            if(e.dataTransfer.files.length) {
                fileInput.files = e.dataTransfer.files;
                updateFileName(e.dataTransfer.files[0].name);
            }
        });

        fileInput.addEventListener('change', function() {
            if(this.files.length) {
                updateFileName(this.files[0].name);
            }
        });

        function updateFileName(name) {
            fileNameDisplay.style.display = 'block';
            fileNameDisplay.innerHTML = `<i class='mdi mdi-file-check me-2'></i> ${name}`;
        }

        // Form Submit Animation
        document.getElementById('uploadForm').addEventListener('submit', function() {
            document.getElementById('btnUpload').innerHTML = "<span class='spinner-border spinner-border-sm me-2'></span> Processing...";
            document.getElementById('btnUpload').disabled = true;
        });
    </script>
</body>
</html>