<?php
// view/dashboard.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// Set Active Page untuk Sidebar
 $activePage = 'dashboard';
 $pageTitle = $lang[$current_lang]['dashboard'];

// Get statistics
 $stmt = $pdo->query("SELECT COUNT(*) FROM spareparts");
 $total_spareparts = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM spareparts WHERE stock < min_stock");
 $low_stock = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM category");
 $total_categories = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM locations");
 $total_locations = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT * FROM activity_log ORDER BY created_at DESC LIMIT 5");
 $activities = $stmt->fetchAll(PDO::FETCH_ASSOC);

 $stmt = $pdo->query("SELECT s.*, c.name as category_name FROM spareparts s LEFT JOIN category c ON s.category_id = c.id WHERE s.stock < s.min_stock ORDER BY s.stock ASC LIMIT 5");
 $low_stock_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - Dashboard</title>
    <!-- CSS Links -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../assets/css/dinar.css" rel="stylesheet">
</head>
<body data-theme="<?= $current_theme ?>" class="text-size-<?= $current_text_size ?> btn-size-<?= $current_btn_size ?> icon-size-<?= $current_icon_size ?>">
    <div class="app-wrapper">
        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        
        <!-- Include Sidebar -->
        <?php include 'includes/sidebar.php'; ?>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Include Header -->
            <?php include 'includes/header.php'; ?>
            
            <!-- Page Content -->
            <div class="page-content">
                <!-- KONTEN HALAMAN DISINI -->
                <div class="page-header fade-in">
                    <div>
                        <h1 class="page-title"><?= $lang[$current_lang]['welcome'] ?>, <?= htmlspecialchars($_SESSION['name']) ?></h1>
                        <p class="page-subtitle"><?= date('l, d F Y') ?></p>
                    </div>
                    <!-- Tombol Add New jika bukan guest -->
                    <?php if ($_SESSION['role'] !== 'guest'): ?>
                    <a href="spareparts.php?action=add" class="btn btn-primary">
                        <i class="mdi mdi-plus"></i> <?= $lang[$current_lang]['add_new'] ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <!-- Statistics Cards -->
                <div class="stat-grid fade-in">
                    <!-- ... (Kode stat card seperti sebelumnya) ... -->
                     <div class="stat-card">
                        <div class="stat-icon"><i class="mdi mdi-cog"></i></div>
                        <div class="stat-content">
                            <h3><?= number_format($total_spareparts) ?></h3>
                            <p>Total Spareparts</p>
                        </div>
                    </div>
                    <!-- ... card lainnya ... -->
                </div>

                <!-- Rows untuk tabel/activity -->
                <div class="row">
                   <!-- ... (Kode tabel dan activity seperti sebelumnya) ... -->
                </div>
            </div>
            
            <!-- Include Footer -->
            <?php include 'includes/footer.php'; ?>
        </main>
    </div>
</body>
</html>