<?php
// view/category.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'category';
 $pageTitle = $lang[$current_lang]['category'];

// Ambil data kategori
 $stmt = $pdo->query("SELECT * FROM category ORDER BY name ASC");
 $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - <?= $pageTitle ?></title>
    
    <!-- CSS Links -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="../assets/css/dinar.css" rel="stylesheet">

    <!-- CSS Custom Fix -->
    <style>
        /* ==========================================
           FIX: TOMBOL AKSI ANTI-MENUMPUK
           ========================================== */
        .action-buttons {
            display: flex !important;
            flex-wrap: nowrap !important; /* Memaksa tombol tetap di 1 baris */
            gap: 4px;
            align-items: center;
            justify-content: center;
        }
        
        .action-buttons .btn {
            padding: 0.25rem 0.5rem;
            font-size: 0.8rem;
            line-height: 1.2;
            white-space: nowrap; /* Ikon tidak berpindah baris */
        }

        /* ==========================================
           FIX: ISI TABEL TIDAK MENUMPUK
           ========================================== */
        .table td, .table th {
            white-space: nowrap; /* Mencegah teks turun ke bawah */
            vertical-align: middle; /* Konten rapi tengah vertikal */
        }

        /* Khusus kolom deskripsi, biarkan bisa wrap karena bisa panjang */
        .table td.desc-col {
            white-space: normal;
        }
    </style>
</head>

<body data-theme="<?= $current_theme ?>" 
      class="text-size-<?= $current_text_size ?> 
             btn-size-<?= $current_btn_size ?> 
             icon-size-<?= $current_icon_size ?>">

    <div class="app-wrapper">
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        
        <!-- Include Sidebar -->
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="main-content">
            <!-- Include Header -->
            <?php include 'includes/header.php'; ?>
            
            <div class="page-content">
                <div class="page-header fade-in">
                    <div>
                        <h1 class="page-title"><?= $pageTitle ?></h1>
                        <p class="page-subtitle"><?= $lang[$current_lang]['manage_category'] ?></p>
                    </div>
                    
                    <?php if ($_SESSION['role'] !== 'guest'): ?>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalForm">
                        <i class="mdi mdi-plus"></i> <?= $lang[$current_lang]['add_new'] ?>
                    </button>
                    <?php endif; ?>
                </div>
                
                <div class="card fade-in">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table data-table">
                                <thead>
                                    <tr>
                                        <th width="50">No</th>
                                        <th><?= $lang[$current_lang]['category_code'] ?></th>
                                        <th><?= $lang[$current_lang]['category_name'] ?></th>
                                        <th class="desc-col"><?= $lang[$current_lang]['description'] ?></th>
                                        <th><?= $lang[$current_lang]['status'] ?></th>
                                        <th width="100" class="text-center"><?= $lang[$current_lang]['action'] ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no=1; foreach($categories as $row): ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><strong><?= htmlspecialchars($row['code']) ?></strong></td>
                                        <td><?= htmlspecialchars($row['name']) ?></td>
                                        <td class="desc-col"><?= htmlspecialchars($row['description']) ?></td>
                                        <td>
                                            <?php if($row['status'] == 'active'): ?>
                                                <span class="badge bg-success"><?= $lang[$current_lang]['active'] ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?= $lang[$current_lang]['inactive'] ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($_SESSION['role'] == 'admin'): ?>
                                            <div class="action-buttons">
                                                <button class="btn btn-sm btn-secondary" onclick="editData(<?= htmlspecialchars(json_encode($row)) ?>)" title="Edit">
                                                    <i class="mdi mdi-pencil"></i>
                                                </button>
                                                
                                                <form action="../post/category_action.php" method="POST" id="formDelete_<?= $row['id'] ?>">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                    <button type="button" class="btn btn-sm btn-danger" onclick="confirmDeleteCategory('formDelete_<?= $row['id'] ?>', '<?= htmlspecialchars($row['name']) ?>')" title="Delete">
                                                        <i class="mdi mdi-trash-can"></i>
                                                    </button>
                                                </form>
                                            </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal Add/Edit -->
            <div class="modal fade" id="modalForm" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalTitle"><?= $lang[$current_lang]['add_category'] ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <form action="../post/category_action.php" method="POST">
                            <div class="modal-body">
                                <input type="hidden" name="action" value="add" id="formAction">
                                <input type="hidden" name="id" id="formId">
                                
                                <div class="mb-3">
                                    <label class="form-label"><?= $lang[$current_lang]['category_code'] ?></label>
                                    <input type="text" name="code" id="formCode" class="form-control" required placeholder="e.g: MECH">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><?= $lang[$current_lang]['category_name'] ?></label>
                                    <input type="text" name="name" id="formName" class="form-control" required placeholder="e.g: Mechanical">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><?= $lang[$current_lang]['description'] ?></label>
                                    <textarea name="description" id="formDesc" class="form-control" rows="3"></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label"><?= $lang[$current_lang]['status'] ?></label>
                                    <select name="status" id="formStatus" class="form-select">
                                        <option value="active"><?= $lang[$current_lang]['active'] ?></option>
                                        <option value="inactive"><?= $lang[$current_lang]['inactive'] ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?></button>
                                <button type="submit" class="btn btn-primary"><?= $lang[$current_lang]['save'] ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <?php include 'includes/footer.php'; ?>
        </main>
    </div>
    
    <script>
        // Fungsi Edit Data
        function editData(data) {
            document.getElementById('modalTitle').innerText = '<?= $lang[$current_lang]['edit_category'] ?>';
            document.getElementById('formAction').value = 'edit';
            document.getElementById('formId').value = data.id;
            document.getElementById('formCode').value = data.code;
            document.getElementById('formName').value = data.name;
            document.getElementById('formDesc').value = data.description;
            document.getElementById('formStatus').value = data.status;
            
            var modal = new bootstrap.Modal(document.getElementById('modalForm'));
            modal.show();
        }
        
        // Reset Modal
        document.getElementById('modalForm').addEventListener('hidden.bs.modal', function () {
            document.getElementById('modalTitle').innerText = '<?= $lang[$current_lang]['add_category'] ?>';
            document.getElementById('formAction').value = 'add';
            document.getElementById('formId').value = '';
            document.getElementById('formCode').value = '';
            document.getElementById('formName').value = '';
            document.getElementById('formDesc').value = '';
            document.getElementById('formStatus').value = 'active';
        });

        // Fungsi Hapus Stabil
        function confirmDeleteCategory(formId, itemName) {
            Swal.fire({
                title: 'Anda Yakin?',
                text: "Kategori \"" + itemName + "\" akan dihapus permanen!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Ya, Hapus!',
                cancelButtonText: 'Batal',
                customClass: {
                    confirmButton: 'btn btn-danger me-2',
                    cancelButton: 'btn btn-secondary'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById(formId).submit();
                }
            });
        }
    </script>
</body>
</html>