<?php
// get/template_receipt.php
require_once '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

 $spreadsheet = new Spreadsheet();
 $sheet = $spreadsheet->getActiveSheet();

// Header Kolom
 $sheet->setCellValue('A1', 'PO Number');
 $sheet->setCellValue('B1', 'Item Code');
 $sheet->setCellValue('C1', 'Item Name');
 $sheet->setCellValue('D1', 'Qty Receive');
 $sheet->setCellValue('E1', 'Price');
 $sheet->setCellValue('F1', 'Invoice No');

// Style Header
 $sheet->getStyle('A1:F1')->getFont()->setBold(true);
 $sheet->getStyle('A1:F1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('FF4F81BD');
 $sheet->getStyle('A1:F1')->getFont()->getColor()->setARGB('FFFFFFFF');

// Contoh Data
 $sheet->setCellValue('A2', 'PO-202601-0001');
 $sheet->setCellValue('B2', 'BP-001');
 $sheet->setCellValue('C2', 'Bearing 6205');
 $sheet->setCellValue('D2', '10');
 $sheet->setCellValue('E2', '150000');
 $sheet->setCellValue('F2', 'INV-001');

// Auto Size
foreach (range('A', 'F') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="template_penerimaan.xlsx"');
header('Cache-Control: max-age=0');

 $writer = new Xlsx($spreadsheet);
 $writer->save('php://output');
exit;
?>