<?php
// get/get_sparepart_detail.php
require_once '../config/config.php';

 $id = intval($_GET['id'] ?? 0);

// Query diupdate: Tambah join ke material_group
 $stmt = $pdo->prepare("
    SELECT s.*, 
           c.name as category_name, 
           l.name as location_name,
           m.name as material_group_name
    FROM spareparts s 
    LEFT JOIN category c ON s.category_id = c.id 
    LEFT JOIN locations l ON s.location_id = l.id 
    LEFT JOIN material_group m ON s.material_group_id = m.id
    WHERE s.id = ?
");
 $stmt->execute([$id]);
 $data = $stmt->fetch(PDO::FETCH_ASSOC);

if($data) {
    $imgStmt = $pdo->prepare("SELECT image_path FROM sparepart_images WHERE sparepart_id = ?");
    $imgStmt->execute([$id]);
    $images = $imgStmt->fetchAll(PDO::FETCH_COLUMN);
    
    if(!$images) $images = [];

    echo json_encode([
        'status' => 'success',
        'data' => $data,
        'images' => $images
    ]);
} else {
    echo json_encode(['status' => 'error', 'msg' => 'Data not found']);
}
?>