<?php
// get/get_po_items.php
require_once '../config/config.php';
header('Content-Type: application/json');

 $po_id = intval($_GET['id'] ?? 0);

if($po_id > 0) {
    try {
        // Perbaikan Query:
        // 1. Ambil data item langsung dari purchase_order_items (karena sudah ada nama, qty, unit)
        // 2. Ambil nama supplier dari tabel purchase_orders
        $stmt = $pdo->prepare("
            SELECT 
                poi.item_code,
                poi.item_name,
                poi.unit,
                poi.qty,
                poi.price,
                po.supplier_name
            FROM purchase_order_items poi
            JOIN purchase_orders po ON poi.po_id = po.id
            WHERE poi.po_id = ?
        ");
        $stmt->execute([$po_id]);
        $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Debugging: Uncomment baris di bawah untuk cek response di browser Network tab jika masih kosong
        // echo json_encode(['status' => 'success', 'items' => $items, 'query' => $stmt->queryString]); die;

        echo json_encode([
            'status' => 'success',
            'items' => $items
        ]);
    } catch (PDOException $e) {
        // Kirim pesan error untuk debugging
        echo json_encode(['status' => 'error', 'msg' => 'Database Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'msg' => 'Invalid ID']);
}
?>