<?php
// get/change_size.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $type = $_GET['type'] ?? 'text';
 $size = $_GET['size'] ?? 'm';

if (in_array($size, ['xs', 's', 'm', 'l'])) {
    // Update Session & DB
    switch($type) {
        case 'text':
            $_SESSION['text_size'] = $size;
            $stmt = $pdo->prepare("UPDATE users SET text_size = ? WHERE id = ?");
            break;
        case 'btn':
            $_SESSION['btn_size'] = $size;
            $stmt = $pdo->prepare("UPDATE users SET btn_size = ? WHERE id = ?");
            break;
        case 'icon':
            $_SESSION['icon_size'] = $size;
            $stmt = $pdo->prepare("UPDATE users SET icon_size = ? WHERE id = ?");
            break;
        default:
            $referer = $_SERVER['HTTP_REFERER'] ?? '../view/dashboard.php';
            header('Location: ' . $referer);
            exit;
    }
    
    $stmt->execute([$size, $_SESSION['user_id']]);
}

 $referer = $_SERVER['HTTP_REFERER'] ?? '../view/dashboard.php';
header('Location: ' . $referer);
exit;
?>