<?php
// config/config.php
session_start();

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'spareparts_db');
define('DB_USER', 'root');
define('DB_PASS', '');

// Application Settings
define('APP_NAME', 'SpareParts Management System');
define('APP_VERSION', '2.0.26');
define('APP_URL', 'http://localhost/spr_2026');

// Theme Configuration
 $themes = [
    'black' => ['primary' => '#1a1a2e', 'secondary' => '#16213e', 'accent' => '#e94560', 'text' => '#eaeaea'],
    'green' => ['primary' => '#0d2818', 'secondary' => '#1a472a', 'accent' => '#00d26a', 'text' => '#e8f5e9'],
    'blue' => ['primary' => '#0a192f', 'secondary' => '#112240', 'accent' => '#64ffda', 'text' => '#ccd6f6'],
    'ungu' => ['primary' => '#2d132c', 'secondary' => '#4a1942', 'accent' => '#ee6c4d', 'text' => '#f0e6f0'],
    'biru_muda' => ['primary' => '#1b262c', 'secondary' => '#0f4c75', 'accent' => '#3282b8', 'text' => '#bbe1fa']
];

// Size Configuration
 $sizes = [
    'text' => ['xs' => '11px', 's' => '13px', 'm' => '15px', 'l' => '17px'],
    'button' => ['xs' => 'padding: 3px 8px; font-size: 11px;', 's' => 'padding: 5px 12px; font-size: 13px;', 'm' => 'padding: 8px 16px; font-size: 14px;', 'l' => 'padding: 12px 24px; font-size: 16px;'],
    'icon' => ['xs' => '12px', 's' => '14px', 'm' => '18px', 'l' => '24px']
];

// Language Configuration
 $lang = [
    'id' => [
        'login_title' => 'Masuk ke Sistem',
        'username' => 'Nama Pengguna',
        'password' => 'Kata Sandi',
        'login_btn' => 'Masuk',
        'dashboard' => 'Beranda',
        'spareparts' => 'Suku Cadang',
        'category' => 'Kategori',
        'locations' => 'Lokasi',
        'material_group' => 'Grup Material',
        'users' => 'Pengguna',
        'settings' => 'Pengaturan',
        'logout' => 'Keluar',
        'welcome' => 'Selamat Datang',
        'total_spareparts' => 'Total Suku Cadang',
        'low_stock' => 'Stok Rendah',
        'categories' => 'Kategori',
        'locations_count' => 'Lokasi',
        'recent_activity' => 'Aktivitas Terbaru',
        'add_new' => 'Tambah Baru',
        'edit' => 'Ubah',
        'delete' => 'Hapus',
        'save' => 'Simpan',
        'cancel' => 'Batal',
        'search' => 'Cari...',
        'action' => 'Aksi',
        'no_data' => 'Tidak ada data',
        'confirm_delete' => 'Apakah Anda yakin ingin menghapus data ini?',
        'code' => 'Kode',
        'name' => 'Nama',
        'description' => 'Deskripsi',
        'status' => 'Status',
        'active' => 'Aktif',
        'inactive' => 'Non-Aktif',
        'add_material_group' => 'Tambah Grup Material',
        'edit_material_group' => 'Ubah Grup Material',
        'manage_material_group' => 'Kelola grup material untuk suku cadang',
        'cannot_delete' => 'Tidak dapat menghapus: Grup sedang digunakan',
        'success_add' => 'Grup material berhasil ditambahkan',
        'success_edit' => 'Grup material berhasil diperbarui',
        'success_delete' => 'Grup material berhasil dihapus',
        'material_location' => 'Lokasi Material',
        'manage_locations' => 'Kelola lokasi penyimpanan dan kapasitas rak',
        'building' => 'Gedung',
        'floor' => 'Lantai',
        'area' => 'Area',
        'max_capacity' => 'Kapasitas Maks',
        'used_capacity' => 'Terisi',
        'remaining_capacity' => 'Sisa Kapasitas',
        'capacity_status' => 'Status Kapasitas',
        'location_code' => 'Kode Lokasi',
        'add_location' => 'Tambah Lokasi',
        'edit_location' => 'Ubah Lokasi',
        'full' => 'Penuh',
        'available' => 'Tersedia',
        'category' => 'Kategori',
        'manage_category' => 'Kelola kategori suku cadang',
        'category_code' => 'Kode Kategori',
        'category_name' => 'Nama Kategori',
        'add_category' => 'Tambah Kategori',
        'edit_category' => 'Ubah Kategori',
        'cannot_delete_category' => 'Tidak dapat menghapus: Kategori sedang digunakan oleh suku cadang',
        'spareparts' => 'Suku Cadang',
        'manage_spareparts' => 'Kelola data suku cadang mesin',
        'part_number' => 'Kode Part',
        'part_name' => 'Nama Barang',
        'stock' => 'Stok',
        'unit' => 'Satuan',
        'price' => 'Harga',
        'images' => 'Gambar',
        'upload_images' => 'Unggah Gambar',
        'view_detail' => 'Lihat Detail',
        'zoom_in' => 'Perbesar',
        'zoom_out' => 'Perkecil',
        'rotate' => 'Putar',
        'no_image' => 'Tidak ada gambar',
        'upload_images' => 'Unggah Gambar',
        'view_detail' => 'Lihat Detail',
        'zoom_in' => 'Perbesar',
        'zoom_out' => 'Perkecil',
        'rotate' => 'Putar',
        'no_image' => 'Tidak ada gambar',
        'import_data' => 'Import Data',
        'import_spareparts' => 'Import Spareparts',
        'import_subtitle' => 'Upload file Excel untuk menambahkan data secara massal',
        'back_to_list' => 'Kembali ke Daftar',
        'upload_file_excel' => 'Upload File Excel',
        'file_format_info' => 'Format file: .xlsx atau .xls (Max 5MB)',
        'drag_drop' => 'Drag & Drop File Disini',
        'or_click_select' => 'atau klik untuk memilih file',
        'download_template' => 'Download Template',
        'process_import' => 'Proses Import',
        'import_guide' => 'Panduan Import',
        'guide_step1' => 'Download template Excel terlebih dahulu.',
        'guide_step2' => 'Isi data spareparts sesuai kolom yang tersedia.',
        'guide_step3' => 'Pastikan Kategori, Lokasi, dan Material Group sesuai dengan data master.',
        'guide_step4' => 'Part Number tidak boleh duplikat.',
        'guide_step5' => 'Upload file yang sudah diisi.',
        'master_data_available' => 'Data Master Tersedia:', 
           // === SCAN IMAGE & BARCODE ===
        'scan_image' => 'Scan Gambar',
        'visual_search' => 'Pencarian Visual',
        'find_parts_by_shape' => 'Temukan sparepart berdasarkan bentuk gambar',
        'upload_take_photo' => 'Upload atau Ambil Foto',
        'drop_image_here' => 'Letakkan gambar di sini',
        'open_camera_file' => 'Buka Kamera / File',
        'how_to_use' => 'Cara Penggunaan',
        'step_1' => 'Ambil Foto',
        'step_1_desc' => 'Gunakan kamera handphone untuk memfoto sparepart yang ingin dicari.',
        'step_2' => 'Pastikan Fokus',
        'step_2_desc' => 'Pastikan foto tidak blur dan pencahayaan cukup terang.',
        'step_3' => 'Sistem Mencari',
        'step_3_desc' => 'Sistem akan mencocokkan bentuk gambar dengan database.',
        'search_results' => 'Hasil Pencarian',
        'no_results' => 'Tidak ada hasil ditemukan',
        'processing_image' => 'Memproses Gambar...',
        'analyzing_visual' => 'Menganalisa kemiripan visual',
        'match' => 'Cocok',
        
        // Barcode Specific
        'scan_barcode' => 'Scan Barcode',
        'scan_mode_barcode' => 'Mode Barcode',
        'scan_mode_image' => 'Mode Gambar',
        'scan_instruction_barcode' => 'Arahkan kamera ke barcode atau QR Code',
        'barcode_not_found' => 'Barcode tidak ditemukan di database',
        'start_scanner' => 'Mulai Scanner',
        'stop_scanner' => 'Hentikan',
        'or_type_barcode' => 'Atau ketik manual:',

        'transactions' => 'Transaksi',
        'trans_in' => 'Penerimaan Barang',
        'trans_out' => 'Penarikan Barang',
        'trans_return' => 'Return Barang',
        'po_list' => 'Daftar PO',
        'po_number' => 'No. PO',
        'po_date' => 'Tanggal',
        'comments' => 'Komentar',
        'pending' => 'Pending',
        'partial' => 'Sebagian',
        'completed' => 'Selesai',
        'cancelled' => 'Batal',
        'goods_receipt' => 'Penerimaan Barang',
        'process_goods_receipt' => 'Proses penerimaan barang masuk',
        'reference_no' => 'No Referensi',
        'select_po_title' => '1. Pilih Purchase Order (PO)',
        'po_number_label' => 'Nomor PO',
        'select_po_placeholder' => '-- Pilih PO untuk mengisi otomatis --',
        'reset_change_po' => 'Reset / Ganti PO',
        'item_details_title' => '2. Detail Barang',
        'scan_barcode_placeholder' => 'Scan Barcode / Input Kode Barang lalu tekan Enter (Manual)',
        'add_item' => 'Tambah Item',
        'item_code' => 'Kode Barang',
        'item_name' => 'Nama Barang',
        'qty' => 'Qty',
        'po_number' => 'No. PO',
        'delete_selected' => 'Hapus Terpilih',
        'save_transaction' => 'Simpan Transaksi',
        'msg_po_empty' => 'PO ini tidak memiliki item.',
        'msg_no_items_save' => 'Tidak ada item untuk disimpan.',
        'msg_confirm_save' => 'Data penerimaan akan disimpan.',
        'msg_success_save_receipt' => 'Penerimaan barang berhasil disimpan!',
        'machines' => 'Daftar Mesin',
        'machine_name' => 'Nama Mesin',
        'machine_year' => 'Tahun',
        'machine_parts' => 'Bagian Mesin',
        'add_machine' => 'Tambah Mesin',
        'edit_machine' => 'Ubah Mesin',
        'detail_parts' => 'Lihat Bagian',
        'add_part' => 'Tambah Bagian',
        'part_name' => 'Nama Bagian',
        'no_parts_yet' => 'Belum ada bagian mesin terdaftar.',
        'success_add_machine' => 'Mesin berhasil ditambahkan',
        'success_edit_machine' => 'Mesin berhasil diperbarui',
        'success_delete_machine' => 'Mesin berhasil dihapus',
        'confirm_delete_machine' => 'Yakin ingin menghapus mesin ini? Semua bagian mesin akan ikut terhapus.',
        'lines' => 'Line / Produk',
        'line_name' => 'Nama Line',
        'product_name' => 'Nama Produk',
        'add_line' => 'Tambah Line',
        'edit_line' => 'Ubah Line',
        'line_detail' => 'Detail Line',
        'select_machine' => 'Pilih Mesin',
        'machine_used' => 'Mesin Digunakan',
        'success_add_line' => 'Line berhasil ditambahkan',
        'success_edit_line' => 'Line berhasil diperbarui',
        'success_delete_line' => 'Line berhasil dihapus',

    ],
    'en' => [
        'login_title' => 'Login to System',
        'username' => 'Username',
        'password' => 'Password',
        'login_btn' => 'Login',
        'dashboard' => 'Dashboard',
        'spareparts' => 'Spare Parts',
        'category' => 'Category',
        'locations' => 'Locations',
        'material_group' => 'Material Group',
        'users' => 'Users',
        'settings' => 'Settings',
        'logout' => 'Logout',
        'welcome' => 'Welcome',
        'total_spareparts' => 'Total Spare Parts',
        'low_stock' => 'Low Stock',
        'categories' => 'Categories',
        'locations_count' => 'Locations',
        'recent_activity' => 'Recent Activity',
        'add_new' => 'Add New',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'search' => 'Search...',
        'action' => 'Action',
        'no_data' => 'No data available',
        'confirm_delete' => 'Are you sure you want to delete this data?',
        'code' => 'Code',
        'name' => 'Name',
        'description' => 'Description',
        'status' => 'Status',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'add_material_group' => 'Add Material Group',
        'edit_material_group' => 'Edit Material Group',
        'manage_material_group' => 'Manage material groups for spareparts',
        'cannot_delete' => 'Cannot delete: Group is in use',
        'success_add' => 'Material group added successfully',
        'success_edit' => 'Material group updated successfully',
        'success_delete' => 'Material group deleted',
        'material_location' => 'Material Location',
        'manage_locations' => 'Manage storage locations and rack capacity',
        'building' => 'Building',
        'floor' => 'Floor',
        'area' => 'Area',
        'max_capacity' => 'Max Capacity',
        'used_capacity' => 'Used',
        'remaining_capacity' => 'Remaining',
        'capacity_status' => 'Capacity Status',
        'location_code' => 'Location Code',
        'add_location' => 'Add Location',
        'edit_location' => 'Edit Location',
        'full' => 'Full',
        'available' => 'Available',
        'category' => 'Category',
        'manage_category' => 'Manage spareparts category',
        'category_code' => 'Category Code',
        'category_name' => 'Category Name',
        'add_category' => 'Add Category',
        'edit_category' => 'Edit Category',
        'cannot_delete_category' => 'Cannot delete: Category is in use by spareparts',
        'spareparts' => 'Spare Parts',
        'manage_spareparts' => 'Manage machine spare parts data',
        'part_number' => 'Part Number',
        'part_name' => 'Part Name',
        'stock' => 'Stock',
        'unit' => 'Unit',
        'price' => 'Price',
        'images' => 'Images',
        'upload_images' => 'Upload Images',
        'view_detail' => 'View Detail',
        'zoom_in' => 'Zoom In',
        'zoom_out' => 'Zoom Out',
        'rotate' => 'Rotate',
        'no_image' => 'No image available',
        'upload_images' => 'Upload Images',
        'view_detail' => 'View Detail',
        'zoom_in' => 'Zoom In',
        'zoom_out' => 'Zoom Out',
        'rotate' => 'Rotate',
        'no_image' => 'No image available',
        'import_data' => 'Import Data',
        'import_spareparts' => 'Import Spareparts',
        'import_subtitle' => 'Upload Excel file to add data in bulk',
        'back_to_list' => 'Back to List',
        'upload_file_excel' => 'Upload Excel File',
       'file_format_info' => 'File format: .xlsx or .xls (Max 5MB)',
        'drag_drop' => 'Drag & Drop File Here',
        'or_click_select' => 'or click to select file',
        'download_template' => 'Download Template',
        'process_import' => 'Process Import',
        'import_guide' => 'Import Guide',
        'guide_step1' => 'Download the Excel template first.',
        'guide_step2' => 'Fill in spareparts data according to the columns.',
        'guide_step3' => 'Ensure Category, Location, and Material Group match the master data.',
        'guide_step4' => 'Part Number cannot be duplicated.',
        'guide_step5' => 'Upload the filled file.',
        'master_data_available' => 'Available Master Data:',
        // === SCAN IMAGE & BARCODE ===
        'scan_image' => 'Scan Image',
        'visual_search' => 'Visual Search',
        'find_parts_by_shape' => 'Find spareparts based on image shape',
        'upload_take_photo' => 'Upload or Take Photo',
        'drop_image_here' => 'Drop image here',
        'open_camera_file' => 'Open Camera / File',
        'how_to_use' => 'How to Use',
        'step_1' => 'Take Photo',
        'step_1_desc' => 'Use your phone camera to take a photo of the sparepart.',
        'step_2' => 'Ensure Focus',
        'step_2_desc' => 'Make sure the photo is not blurry and lighting is sufficient.',
        'step_3' => 'System Search',
        'step_3_desc' => 'The system will match the image shape with the database.',
        'search_results' => 'Search Results',
        'no_results' => 'No results found',
        'processing_image' => 'Processing Image...',
        'analyzing_visual' => 'Analyzing visual similarity',
        'match' => 'Match',

        // Barcode Specific
        'scan_barcode' => 'Scan Barcode',
        'scan_mode_barcode' => 'Barcode Mode',
        'scan_mode_image' => 'Image Mode',
        'scan_instruction_barcode' => 'Point camera to barcode or QR Code',
        'barcode_not_found' => 'Barcode not found in database',
        'start_scanner' => 'Start Scanner',
        'stop_scanner' => 'Stop',
        'or_type_barcode' => 'Or type manually:',
        'transactions' => 'Transactions',
        'trans_in' => 'Goods Receipt',
        'trans_out' => 'Goods Withdrawal',
        'trans_return' => 'Goods Return',
        'po_list' => 'PO List',
        'po_number' => 'PO Number',
        'po_date' => 'Date',
        'comments' => 'Comments',
        'pending' => 'Pending',
        'partial' => 'Partial',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
        'goods_receipt' => 'Goods Receipt',
        'process_goods_receipt' => 'Process incoming goods receipt',
        'reference_no' => 'Reference No',
        'select_po_title' => '1. Select Purchase Order (PO)',
        'po_number_label' => 'PO Number',
        'select_po_placeholder' => '-- Select PO to autofill --',
        'reset_change_po' => 'Reset / Change PO',
        'item_details_title' => '2. Item Details',
        'scan_barcode_placeholder' => 'Scan Barcode / Input Item Code then press Enter (Manual)',
        'add_item' => 'Add Item',
        'item_code' => 'Item Code',
        'item_name' => 'Item Name',
        'qty' => 'Qty',
        'po_number' => 'PO Number',
        'delete_selected' => 'Delete Selected',
        'save_transaction' => 'Save Transaction',
        'msg_po_empty' => 'This PO has no items.',
        'msg_no_items_save' => 'No items to save.',
        'msg_confirm_save' => 'Receipt data will be saved.',
        'msg_success_save_receipt' => 'Goods receipt saved successfully!',
        'machines' => 'Machine List',
        'machine_name' => 'Machine Name',
        'machine_year' => 'Year',
        'machine_parts' => 'Machine Parts',
        'add_machine' => 'Add Machine',
        'edit_machine' => 'Edit Machine',
        'detail_parts' => 'View Parts',
        'add_part' => 'Add Part',
        'part_name' => 'Part Name',
        'no_parts_yet' => 'No machine parts registered yet.',
        'success_add_machine' => 'Machine added successfully',
        'success_edit_machine' => 'Machine updated successfully',
        'success_delete_machine' => 'Machine deleted successfully',
        'confirm_delete_machine' => 'Are you sure to delete this machine? All related parts will be deleted.',
        'lines' => 'Line / Product',
        'line_name' => 'Line Name',
        'product_name' => 'Product Name',
        'add_line' => 'Add Line',
        'edit_line' => 'Edit Line',
        'line_detail' => 'Line Detail',
        'select_machine' => 'Select Machine',
        'machine_used' => 'Machine Used',
        'success_add_line' => 'Line added successfully',
        'success_edit_line' => 'Line updated successfully',
        'success_delete_line' => 'Line deleted successfully'   
    ]
];

// Get current language
 $current_lang = $_SESSION['lang'] ?? 'id';
 $current_theme = $_SESSION['theme'] ?? 'black';
 $current_text_size = $_SESSION['text_size'] ?? 'm';
 $current_btn_size = $_SESSION['btn_size'] ?? 'm';
 $current_icon_size = $_SESSION['icon_size'] ?? 'm';

// Database Connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
?>