SpareParts Management System

Version: 1.0.0
Author: [Nama Anda/Tim]
Last Updated: 2026
📖 Deskripsi Proyek

Sistem manajemen inventaris spare parts mesin konversi tissue. Aplikasi ini dibangun menggunakan PHP Native (Procedural) dengan desain UI Modern (Neumorphism/Glassmorphism) yang responsif dan mendukung tema gelap (Dark Mode).
✨ Fitur Utama

    Manajemen Data Spareparts: CRUD lengkap dengan upload multiple gambar.
    Image Viewer: Fitur Zoom In/Out, Rotate, dan Drag & Drop untuk gambar spareparts.
    Import Excel: Upload massal data spareparts menggunakan file Excel (.xlsx/.xls).
    Master Data: Pengelolaan Category, Locations, dan Material Group.
    Dynamic UI:
        5 Tema Warna: Black, Green, Blue, Ungu, Biru Muda.
        Multi-bahasa: Indonesia & English.
        Dynamic Sizing: Ukuran Teks, Tombol, dan Ikon bisa diubah secara real-time.
    Dashboard: Statistik stok, notifikasi stok rendah, dan log aktivitas.
    Responsive Design: Tampilan optimal di Desktop, Tablet, dan Mobile.

🛠️ Tech Stack (Teknologi)

    Backend: PHP 8.3+ (Native PDO)
    Database: MySQL / MariaDB
    Frontend: 
        Bootstrap 5.3.2
        Material Design Icons (MDI)
        DataTables (dengan ScrollX)
        Select2
        SweetAlert2
    Library:
        PhpSpreadsheet: Untuk proses import/export file Excel.
        Composer: Dependency Manager.

📂 Struktur Folder
 

spareparts_db/
├── assets/
│   ├── css/
│   │   └── dinar.css        # File CSS utama (semua tema & ukuran ada disini)
│   ├── img/
│   │   └── product/         # Folder upload gambar spareparts
│   └── js/
│       └── dinar.js         # Logic JS utama (Sidebar, DataTables, Delete)
├── config/
│   └── config.php           # Konfigurasi DB, Bahasa, Session
├── get/
│   ├── change_lang.php      # Handler ganti bahasa
│   ├── change_theme.php     # Handler ganti tema
│   ├── change_size.php      # Handler ganti ukuran
│   ├── get_sparepart_detail.php # API detail sparepart (JSON)
│   └── template_spareparts.php  # Generator template Excel
├── post/
│   ├── spareparts_action.php    # Handler Add/Edit/Delete/Import Spareparts
│   ├── category_action.php
│   ├── locations_action.php
│   └── material_group_action.php
├── vendor/                  # Folder library Composer (PhpSpreadsheet)
├── view/
│   ├── includes/
│   │   ├── header.php       # Header global & dropdown setting
│   │   ├── sidebar.php      # Menu navigasi
│   │   └── footer.php       # Footer & script global
│   ├── dashboard.php
│   ├── spareparts.php
│   ├── category.php
│   ├── locations.php
│   ├── material_group.php
│   └── import_spareparts.php
├── composer.json            # Daftar dependency PHP
├── README.md                # File dokumentasi ini
└── index.php                # Halaman Login 
text
 
  
 

## 🚀 Panduan Instalasi (Dari Nol)

Ikuti langkah-langkah ini jika ingin memindahkan project ke komputer/server baru:

### 1. Persiapan Server
Pastikan server (XAMPP/Laragon/Linux) memiliki:
- PHP versi **8.3** atau lebih baru.
- Ekstensi PHP aktif: `pdo_mysql`, `zip`, `xml`, `gd`, `mbstring`.

### 2. Install Dependency PHP
Buka terminal di folder project, jalankan:
```bash
composer install
 
 
 

Jika error, pastikan PHP path benar. Jika pakai Linux: sudo composer install --ignore-platform-reqs. 
3. Setup Database 

    Buat database baru di phpMyAdmin (misal: spareparts_db). 
    Import file SQL dump (jika ada) atau jalankan SQL query untuk membuat tabel:
         users
         spareparts
         category
         locations
         material_group
         sparepart_images
         activity_log
         settings
          

4. Konfigurasi Koneksi 

Edit file config/config.php: 
php
 
  
 
define('DB_HOST', 'localhost');
define('DB_NAME', 'spareparts_db');
define('DB_USER', 'root');     // Sesuaikan
define('DB_PASS', '');         // Sesuaikan
define('APP_NAME', 'SpareParts Management');
define('APP_URL', 'http://localhost/spareparts_db'); // Sesuaikan dengan URL folder Anda
 
 
 
5. Aplikasi Siap Digunakan 

Akses melalui browser: http://localhost/spareparts_db/ 
🔑 Default Login 

     Username: admin
     Password: password
     

⚠️ Troubleshooting (Masalah Umum) 
1. Error "Class 'PhpOffice\PhpSpreadsheet\IOFactory' not found" 

Penyebab: Library PhpSpreadsheet belum terinstall.
Solusi: Jalankan composer require phpoffice/phpspreadsheet di terminal folder project. 
2. Tombol Hapus/Edit Tidak Berfungsi 

Penyebab: Konflik script DataTables.
Solusi: Pastikan inisialisasi DataTables hanya ada di assets/js/dinar.js. Hapus inisialisasi duplikat di file view lain. 
3. Gambar Tidak Muncul 

Penyebab: Folder assets/img/product tidak ada atau tidak bisa ditulis (permission denied).
Solusi:  

     Buat folder product di dalam assets/img/.
     Ubah permission (Linux): chmod 755 -R assets/img/product.
     

4. Data Select2 Tidak Muncul (Blank) 

Penyebab: Z-index dropdown tertutup modal atau query error.
Solusi:  

     Cek error di Console Browser (F12).
     Pastikan tabel category, locations, material_group tidak kosong.
     

🛣️ Roadmap (Rencana Pengembangan) 

Fitur yang bisa ditambahkan di masa depan: 

     Export data ke PDF.
     Sistem notifikasi email untuk stok menipis.
     API Endpoint untuk integrasi mobile app.
     Multi-user role permission yang lebih detail (ACL).
     

