<?php
// view/dashboard.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// Get statistics
 $stmt = $pdo->query("SELECT COUNT(*) FROM spareparts");
 $total_spareparts = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM spareparts WHERE stock < min_stock");
 $low_stock = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM category");
 $total_categories = $stmt->fetchColumn();

 $stmt = $pdo->query("SELECT COUNT(*) FROM locations");
 $total_locations = $stmt->fetchColumn();

// Recent activities
 $stmt = $pdo->query("SELECT * FROM activity_log ORDER BY created_at DESC LIMIT 5");
 $activities = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Low stock items
 $stmt = $pdo->query("SELECT s.*, c.name as category_name, l.name as location_name 
                     FROM spareparts s 
                     LEFT JOIN category c ON s.category_id = c.id 
                     LEFT JOIN locations l ON s.location_id = l.id 
                     WHERE s.stock < s.min_stock 
                     ORDER BY s.stock ASC 
                     LIMIT 5");
 $low_stock_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500;600&display=swap" rel="stylesheet">
    <link href="../assets/css/dinar.css" rel="stylesheet">
</head>
<!-- Perubahan: Class ukuran dipindahkan ke BODY untuk pengaruh global -->
<body data-theme="<?= $current_theme ?>" 
      class="text-size-<?= $current_text_size ?> 
             btn-size-<?= $current_btn_size ?> 
             icon-size-<?= $current_icon_size ?>">
    
    <div class="app-wrapper">
        <!-- Sidebar Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <a href="dashboard.php" class="sidebar-logo">
                    <div class="logo-icon">
                        <svg viewBox="0 0 48 48" fill="none">
                            <path d="M24 4L42 14V34L24 44L6 34V14L24 4Z" stroke="currentColor" stroke-width="2" fill="none"/>
                            <path d="M24 14L33 19.5V30.5L24 36L15 30.5V19.5L24 14Z" fill="currentColor" opacity="0.3"/>
                            <circle cx="24" cy="24" r="4" fill="currentColor"/>
                        </svg>
                    </div>
                    <div class="logo-text">
                        <h1>SpareParts</h1>
                        <span>Management</span>
                    </div>
                </a>
            </div>
            
            <nav class="sidebar-menu">
                <div class="menu-section">
                    <div class="menu-section-title">Main Menu</div>
                    <a href="dashboard.php" class="menu-item active">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span><?= $lang[$current_lang]['dashboard'] ?></span>
                    </a>
                    <a href="spareparts.php" class="menu-item">
                        <i class="mdi mdi-cog"></i>
                        <span><?= $lang[$current_lang]['spareparts'] ?></span>
                        <span class="menu-badge"><?= $total_spareparts ?></span>
                    </a>
                    <a href="category.php" class="menu-item">
                        <i class="mdi mdi-folder-outline"></i>
                        <span><?= $lang[$current_lang]['category'] ?></span>
                    </a>
                    <a href="locations.php" class="menu-item">
                        <i class="mdi mdi-map-marker-outline"></i>
                        <span><?= $lang[$current_lang]['locations'] ?></span>
                    </a>
                    <a href="material_group.php" class="menu-item">
                        <i class="mdi mdi-group"></i>
                        <span><?= $lang[$current_lang]['material_group'] ?></span>
                    </a>
                </div>
                
                <?php if ($_SESSION['role'] === 'admin'): ?>
                <div class="menu-section">
                    <div class="menu-section-title">Administration</div>
                    <a href="users.php" class="menu-item">
                        <i class="mdi mdi-account-group"></i>
                        <span><?= $lang[$current_lang]['users'] ?></span>
                    </a>
                    <a href="settings.php" class="menu-item">
                        <i class="mdi mdi-cog-outline"></i>
                        <span><?= $lang[$current_lang]['settings'] ?></span>
                    </a>
                </div>
                <?php endif; ?>
            </nav>
            
            <div class="sidebar-footer">
                <div class="user-info">
                    <div class="user-avatar">
                        <?= strtoupper(substr($_SESSION['name'], 0, 1)) ?>
                    </div>
                    <div class="user-details">
                        <h4><?= htmlspecialchars($_SESSION['name']) ?></h4>
                        <span><?= ucfirst($_SESSION['role']) ?></span>
                    </div>
                </div>
            </div>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            <header class="header">
                <div class="header-left">
                    <button class="sidebar-toggle" id="sidebarToggle">
                        <i class="mdi mdi-menu"></i>
                    </button>
                    <nav class="breadcrumb">
                        <a href="dashboard.php">Home</a>
                        <i class="mdi mdi-chevron-right"></i>
                        <span><?= $lang[$current_lang]['dashboard'] ?></span>
                    </nav>
                </div>
                <div class="header-right">
                    <div class="dropdown">
                        <button class="header-btn" data-bs-toggle="dropdown">
                            <i class="mdi mdi-translate"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                            <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <button class="header-btn" data-bs-toggle="dropdown">
                            <i class="mdi mdi-palette"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                            <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                            <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                            <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                            <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <button class="header-btn" data-bs-toggle="dropdown">
                            <i class="mdi mdi-format-size"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><h6 class="dropdown-header">Text Size</h6></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=xs">Extra Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=s">Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=m">Medium</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=l">Large</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><h6 class="dropdown-header">Button Size</h6></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=xs">Extra Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=s">Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=m">Medium</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=btn&size=l">Large</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><h6 class="dropdown-header">Icon Size</h6></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=xs">Extra Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=s">Small</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=m">Medium</a></li>
                            <li><a class="dropdown-item" href="../get/change_size.php?type=icon&size=l">Large</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <button class="header-btn" data-bs-toggle="dropdown">
                            <i class="mdi mdi-bell-outline"></i>
                            <span class="badge"><?= $low_stock ?></span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" style="width: 300px;">
                            <li><h6 class="dropdown-header">Low Stock Alert</h6></li>
                            <?php foreach ($low_stock_items as $item): ?>
                            <li><a class="dropdown-item" href="spareparts.php?id=<?= $item['id'] ?>">
                                <div class="d-flex justify-content-between">
                                    <span><?= htmlspecialchars($item['name']) ?></span>
                                    <span class="text-danger"><?= $item['stock'] ?> left</span>
                                </div>
                            </a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <button class="header-btn" data-bs-toggle="dropdown">
                            <i class="mdi mdi-account"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                        </ul>
                    </div>
                </div>
            </header>
            
            <!-- Page Content -->
            <!-- Perubahan: Menghapus class text-size di sini karena sudah ada di body -->
            <div class="page-content">
                <div class="page-header fade-in">
                    <div>
                        <h1 class="page-title"><?= $lang[$current_lang]['welcome'] ?>, <?= htmlspecialchars($_SESSION['name']) ?></h1>
                        <p class="page-subtitle"><?= date('l, d F Y') ?></p>
                    </div>
                    <?php if ($_SESSION['role'] !== 'guest'): ?>
                    <!-- Perubahan: Menghapus class size di tombol karena CSS global sudah mengatur -->
                    <a href="spareparts.php?action=add" class="btn btn-primary">
                        <i class="mdi mdi-plus"></i>
                        <?= $lang[$current_lang]['add_new'] ?>
                    </a>
                    <?php endif; ?>
                </div>
                
                <!-- Statistics -->
                <div class="stat-grid fade-in">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <i class="mdi mdi-cog"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?= number_format($total_spareparts) ?></h3>
                            <p><?= $lang[$current_lang]['total_spareparts'] ?></p>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #e94560, #16213e);">
                            <i class="mdi mdi-alert"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?= number_format($low_stock) ?></h3>
                            <p><?= $lang[$current_lang]['low_stock'] ?></p>
                        </div>
                        <span class="stat-trend down"><?= $lang[$current_lang]['low_stock'] ?></span>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #00d26a, #0d2818);">
                            <i class="mdi mdi-folder"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?= number_format($total_categories) ?></h3>
                            <p><?= $lang[$current_lang]['categories'] ?></p>
                        </div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-icon" style="background: linear-gradient(135deg, #64ffda, #0a192f);">
                            <i class="mdi mdi-map-marker"></i>
                        </div>
                        <div class="stat-content">
                            <h3><?= number_format($total_locations) ?></h3>
                            <p><?= $lang[$current_lang]['locations_count'] ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <!-- Recent Activity -->
                    <div class="col-lg-6 mb-4">
                        <div class="card fade-in">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="mdi mdi-history me-2"></i>
                                    <?= $lang[$current_lang]['recent_activity'] ?>
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="list-group list-group-flush">
                                    <?php if (empty($activities)): ?>
                                    <div class="p-4 text-center text-muted">
                                        <i class="mdi mdi-information-outline mdi-36px d-block mb-2"></i>
                                        <?= $lang[$current_lang]['no_data'] ?>
                                    </div>
                                    <?php else: ?>
                                    <?php foreach ($activities as $activity): ?>
                                    <div class="list-group-item bg-transparent border-color: var(--card-border);">
                                        <div class="d-flex align-items-center gap-3">
                                            <div class="stat-icon" style="width: 36px; height: 36px; font-size: 16px;">
                                                <i class="mdi <?= $activity['icon'] ?? 'mdi-information' ?>"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <p class="mb-0"><?= htmlspecialchars($activity['description']) ?></p>
                                                <small class="text-muted"><?= date('d M Y H:i', strtotime($activity['created_at'])) ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Low Stock Items -->
                    <div class="col-lg-6 mb-4">
                        <div class="card fade-in">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="mdi mdi-alert-circle me-2 text-danger"></i>
                                    <?= $lang[$current_lang]['low_stock'] ?>
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <thead>
                                            <tr>
                                                <th>Part Name</th>
                                                <th>Category</th>
                                                <th>Stock</th>
                                                <th>Min</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (empty($low_stock_items)): ?>
                                            <tr>
                                                <td colspan="4" class="text-center text-muted py-4">
                                                    <i class="mdi mdi-check-circle mdi-24px d-block mb-2 text-success"></i>
                                                    All items are well stocked
                                                </td>
                                            </tr>
                                            <?php else: ?>
                                            <?php foreach ($low_stock_items as $item): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($item['name']) ?></td>
                                                <td><span class="badge bg-secondary"><?= htmlspecialchars($item['category_name']) ?></span></td>
                                                <td><span class="badge bg-danger"><?= $item['stock'] ?></span></td>
                                                <td><?= $item['min_stock'] ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Footer -->
            <footer class="footer">
                <p>SpareParts Management System v<?= APP_VERSION ?> - Tissue Converting Machine Solutions</p>
            </footer>
        </main>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="../assets/js/dinar.js"></script>
</body>
</html>