-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Feb 18, 2026 at 07:51 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.0.30

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `spareparts_db`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity_log`
--

CREATE TABLE `activity_log` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(50) DEFAULT 'mdi-information',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` int(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category`
--

INSERT INTO `category` (`id`, `code`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES
(1, 'MECH', 'Mechanical', 'Mechanical parts and components', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(2, 'ELEC', 'Electrical', 'Electrical components and wiring', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(3, 'HYD', 'Hydraulic', 'Hydraulic system parts', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(4, 'PNEU', 'Pneumatic', 'Pneumatic system components', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(5, 'CONS', 'Consumables', 'Consumable items and supplies', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35');

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE `locations` (
  `id` int(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `building` varchar(50) DEFAULT NULL,
  `floor` varchar(20) DEFAULT NULL,
  `area` varchar(50) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locations`
--

INSERT INTO `locations` (`id`, `code`, `name`, `building`, `floor`, `area`, `status`, `created_at`, `updated_at`) VALUES
(1, 'WH-A1', 'Warehouse A1', 'Building A', '1', 'East Wing', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(2, 'WH-A2', 'Warehouse A2', 'Building A', '2', 'West Wing', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(3, 'WH-B1', 'Warehouse B1', 'Building B', '1', 'North Wing', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(4, 'WH-B2', 'Warehouse B2', 'Building B', '2', 'South Wing', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35');

-- --------------------------------------------------------

--
-- Table structure for table `material_group`
--

CREATE TABLE `material_group` (
  `id` int(11) NOT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `material_group`
--

INSERT INTO `material_group` (`id`, `code`, `name`, `description`, `status`, `created_at`, `updated_at`) VALUES
(1, 'RAW', 'Raw Materials', 'Raw material components', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(2, 'SEMI', 'Semi-Finished', 'Semi-finished goods', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(3, 'FIN', 'Finished', 'Finished products', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(4, 'PKG', 'Packaging', 'Packaging materials', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `spareparts`
--

CREATE TABLE `spareparts` (
  `id` int(11) NOT NULL,
  `part_number` varchar(50) NOT NULL,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `material_group_id` int(11) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `min_stock` int(11) DEFAULT 5,
  `max_stock` int(11) DEFAULT 100,
  `unit` varchar(20) DEFAULT 'pcs',
  `price` decimal(15,2) DEFAULT 0.00,
  `machine_type` varchar(100) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `spareparts`
--

INSERT INTO `spareparts` (`id`, `part_number`, `name`, `description`, `category_id`, `location_id`, `material_group_id`, `stock`, `min_stock`, `max_stock`, `unit`, `price`, `machine_type`, `image`, `status`, `created_at`, `updated_at`) VALUES
(1, 'BP-001', 'Bearing 6205', 'Deep groove ball bearing', 1, 1, 3, 25, 10, 100, 'pcs', 150000.00, 'Rewinder', NULL, 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(2, 'BP-002', 'Bearing 6206', 'Deep groove ball bearing', 1, 1, 3, 15, 10, 100, 'pcs', 175000.00, 'Rewinder', NULL, 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(3, 'BLT-001', 'Belt V-A42', 'V-belt for main drive', 1, 2, 3, 8, 5, 50, 'pcs', 250000.00, 'Converting', NULL, 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(4, 'MTR-001', 'Motor 5kW', 'AC induction motor', 2, 3, 3, 2, 1, 10, 'pcs', 5000000.00, 'Main Drive', NULL, 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35'),
(5, 'SNS-001', 'Proximity Sensor', 'Inductive proximity sensor', 2, 1, 3, 12, 5, 50, 'pcs', 350000.00, 'Control System', NULL, 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `role` enum('admin','maintenance','guest') DEFAULT 'guest',
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `theme` varchar(20) DEFAULT 'black',
  `lang` varchar(10) DEFAULT 'id',
  `text_size` varchar(5) DEFAULT 'm',
  `btn_size` varchar(5) DEFAULT 'm',
  `icon_size` varchar(5) DEFAULT 'm'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `full_name`, `email`, `role`, `status`, `created_at`, `updated_at`, `theme`, `lang`, `text_size`, `btn_size`, `icon_size`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrator', 'admin@company.com', 'admin', 'active', '2026-02-18 18:04:35', '2026-02-18 18:51:43', 'biru_muda', 'en', 'xs', 'xs', 'xs'),
(2, 'maintenance', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Maintenance Team', 'maintenance@company.com', 'maintenance', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35', 'black', 'id', 'm', 'm', 'm'),
(3, 'guest', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Guest User', 'guest@company.com', 'guest', 'active', '2026-02-18 18:04:35', '2026-02-18 18:04:35', 'black', 'id', 'm', 'm', 'm');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `activity_log`
--
ALTER TABLE `activity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `category`
--
ALTER TABLE `category`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `locations`
--
ALTER TABLE `locations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `material_group`
--
ALTER TABLE `material_group`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `spareparts`
--
ALTER TABLE `spareparts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `part_number` (`part_number`),
  ADD KEY `category_id` (`category_id`),
  ADD KEY `location_id` (`location_id`),
  ADD KEY `material_group_id` (`material_group_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `activity_log`
--
ALTER TABLE `activity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `category`
--
ALTER TABLE `category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `locations`
--
ALTER TABLE `locations`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `material_group`
--
ALTER TABLE `material_group`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `spareparts`
--
ALTER TABLE `spareparts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `activity_log`
--
ALTER TABLE `activity_log`
  ADD CONSTRAINT `activity_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `spareparts`
--
ALTER TABLE `spareparts`
  ADD CONSTRAINT `spareparts_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `category` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `spareparts_ibfk_2` FOREIGN KEY (`location_id`) REFERENCES `locations` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `spareparts_ibfk_3` FOREIGN KEY (`material_group_id`) REFERENCES `material_group` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
