<?php
// get/change_theme.php
require_once '../config/config.php';

// Cek login
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $theme = $_GET['theme'] ?? 'black';
 $allowed = ['black', 'green', 'blue', 'ungu', 'biru_muda'];

if (in_array($theme, $allowed)) {
    // 1. Update Session
    $_SESSION['theme'] = $theme;
    
    // 2. Update Database
    $stmt = $pdo->prepare("UPDATE users SET theme = ? WHERE id = ?");
    $stmt->execute([$theme, $_SESSION['user_id']]);
    
    // Flash message (opsional)
    $_SESSION['flash'] = ['type' => 'success', 'msg' => 'Theme updated'];
}

 $referer = $_SERVER['HTTP_REFERER'] ?? '../view/dashboard.php';
header('Location: ' . $referer);
exit;
?>