<?php
// config/config.php
session_start();

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'spareparts_db');
define('DB_USER', 'root');
define('DB_PASS', '');

// Application Settings
define('APP_NAME', 'SpareParts Management System');
define('APP_VERSION', '2.0.26');
define('APP_URL', 'http://localhost/spr_2026');

// Theme Configuration
 $themes = [
    'black' => ['primary' => '#1a1a2e', 'secondary' => '#16213e', 'accent' => '#e94560', 'text' => '#eaeaea'],
    'green' => ['primary' => '#0d2818', 'secondary' => '#1a472a', 'accent' => '#00d26a', 'text' => '#e8f5e9'],
    'blue' => ['primary' => '#0a192f', 'secondary' => '#112240', 'accent' => '#64ffda', 'text' => '#ccd6f6'],
    'ungu' => ['primary' => '#2d132c', 'secondary' => '#4a1942', 'accent' => '#ee6c4d', 'text' => '#f0e6f0'],
    'biru_muda' => ['primary' => '#1b262c', 'secondary' => '#0f4c75', 'accent' => '#3282b8', 'text' => '#bbe1fa']
];

// Size Configuration
 $sizes = [
    'text' => ['xs' => '11px', 's' => '13px', 'm' => '15px', 'l' => '17px'],
    'button' => ['xs' => 'padding: 3px 8px; font-size: 11px;', 's' => 'padding: 5px 12px; font-size: 13px;', 'm' => 'padding: 8px 16px; font-size: 14px;', 'l' => 'padding: 12px 24px; font-size: 16px;'],
    'icon' => ['xs' => '12px', 's' => '14px', 'm' => '18px', 'l' => '24px']
];

// Language Configuration
 $lang = [
    'id' => [
        'login_title' => 'Masuk ke Sistem',
        'username' => 'Nama Pengguna',
        'password' => 'Kata Sandi',
        'login_btn' => 'Masuk',
        'dashboard' => 'Beranda',
        'spareparts' => 'Suku Cadang',
        'category' => 'Kategori',
        'locations' => 'Lokasi',
        'material_group' => 'Grup Material',
        'users' => 'Pengguna',
        'settings' => 'Pengaturan',
        'logout' => 'Keluar',
        'welcome' => 'Selamat Datang',
        'total_spareparts' => 'Total Suku Cadang',
        'low_stock' => 'Stok Rendah',
        'categories' => 'Kategori',
        'locations_count' => 'Lokasi',
        'recent_activity' => 'Aktivitas Terbaru',
        'add_new' => 'Tambah Baru',
        'edit' => 'Ubah',
        'delete' => 'Hapus',
        'save' => 'Simpan',
        'cancel' => 'Batal',
        'search' => 'Cari...',
        'action' => 'Aksi',
        'no_data' => 'Tidak ada data',
        'confirm_delete' => 'Apakah Anda yakin ingin menghapus data ini?'
    ],
    'en' => [
        'login_title' => 'Login to System',
        'username' => 'Username',
        'password' => 'Password',
        'login_btn' => 'Login',
        'dashboard' => 'Dashboard',
        'spareparts' => 'Spare Parts',
        'category' => 'Category',
        'locations' => 'Locations',
        'material_group' => 'Material Group',
        'users' => 'Users',
        'settings' => 'Settings',
        'logout' => 'Logout',
        'welcome' => 'Welcome',
        'total_spareparts' => 'Total Spare Parts',
        'low_stock' => 'Low Stock',
        'categories' => 'Categories',
        'locations_count' => 'Locations',
        'recent_activity' => 'Recent Activity',
        'add_new' => 'Add New',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'search' => 'Search...',
        'action' => 'Action',
        'no_data' => 'No data available',
        'confirm_delete' => 'Are you sure you want to delete this data?'
    ]
];

// Get current language
 $current_lang = $_SESSION['lang'] ?? 'id';
 $current_theme = $_SESSION['theme'] ?? 'black';
 $current_text_size = $_SESSION['text_size'] ?? 'm';
 $current_btn_size = $_SESSION['btn_size'] ?? 'm';
 $current_icon_size = $_SESSION['icon_size'] ?? 'm';

// Database Connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
?>